/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.BindAuthKeyInner;

public final class ImmutableBindAuthKeyInner
implements BindAuthKeyInner {
    private final int identifier;
    private final long nonce;
    private final long tempAuthKeyId;
    private final long permAuthKeyId;
    private final long tempSessionId;
    private final int expiresAt;

    private ImmutableBindAuthKeyInner(long nonce, long tempAuthKeyId, long permAuthKeyId, long tempSessionId, int expiresAt) {
        this.nonce = nonce;
        this.tempAuthKeyId = tempAuthKeyId;
        this.permAuthKeyId = permAuthKeyId;
        this.tempSessionId = tempSessionId;
        this.expiresAt = expiresAt;
        this.identifier = BindAuthKeyInner.super.identifier();
    }

    private ImmutableBindAuthKeyInner(Builder builder) {
        this.nonce = builder.nonce;
        this.tempAuthKeyId = builder.tempAuthKeyId;
        this.permAuthKeyId = builder.permAuthKeyId;
        this.tempSessionId = builder.tempSessionId;
        this.expiresAt = builder.expiresAt;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BindAuthKeyInner.super.identifier();
    }

    private ImmutableBindAuthKeyInner(int identifier, long nonce, long tempAuthKeyId, long permAuthKeyId, long tempSessionId, int expiresAt) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.tempAuthKeyId = tempAuthKeyId;
        this.permAuthKeyId = permAuthKeyId;
        this.tempSessionId = tempSessionId;
        this.expiresAt = expiresAt;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long nonce() {
        return this.nonce;
    }

    @Override
    public long tempAuthKeyId() {
        return this.tempAuthKeyId;
    }

    @Override
    public long permAuthKeyId() {
        return this.permAuthKeyId;
    }

    @Override
    public long tempSessionId() {
        return this.tempSessionId;
    }

    @Override
    public int expiresAt() {
        return this.expiresAt;
    }

    public final ImmutableBindAuthKeyInner withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(value, this.nonce, this.tempAuthKeyId, this.permAuthKeyId, this.tempSessionId, this.expiresAt);
    }

    public final ImmutableBindAuthKeyInner withNonce(long value) {
        if (this.nonce == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(this.identifier, value, this.tempAuthKeyId, this.permAuthKeyId, this.tempSessionId, this.expiresAt);
    }

    public final ImmutableBindAuthKeyInner withTempAuthKeyId(long value) {
        if (this.tempAuthKeyId == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(this.identifier, this.nonce, value, this.permAuthKeyId, this.tempSessionId, this.expiresAt);
    }

    public final ImmutableBindAuthKeyInner withPermAuthKeyId(long value) {
        if (this.permAuthKeyId == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(this.identifier, this.nonce, this.tempAuthKeyId, value, this.tempSessionId, this.expiresAt);
    }

    public final ImmutableBindAuthKeyInner withTempSessionId(long value) {
        if (this.tempSessionId == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(this.identifier, this.nonce, this.tempAuthKeyId, this.permAuthKeyId, value, this.expiresAt);
    }

    public final ImmutableBindAuthKeyInner withExpiresAt(int value) {
        if (this.expiresAt == value) {
            return this;
        }
        return new ImmutableBindAuthKeyInner(this.identifier, this.nonce, this.tempAuthKeyId, this.permAuthKeyId, this.tempSessionId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBindAuthKeyInner && this.equalTo(0, (ImmutableBindAuthKeyInner)another);
    }

    private boolean equalTo(int synthetic, ImmutableBindAuthKeyInner another) {
        return this.identifier == another.identifier && this.nonce == another.nonce && this.tempAuthKeyId == another.tempAuthKeyId && this.permAuthKeyId == another.permAuthKeyId && this.tempSessionId == another.tempSessionId && this.expiresAt == another.expiresAt;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.nonce);
        h += (h << 5) + Long.hashCode(this.tempAuthKeyId);
        h += (h << 5) + Long.hashCode(this.permAuthKeyId);
        h += (h << 5) + Long.hashCode(this.tempSessionId);
        h += (h << 5) + this.expiresAt;
        return h;
    }

    public String toString() {
        return "BindAuthKeyInner{identifier=" + this.identifier + ", nonce=" + this.nonce + ", tempAuthKeyId=" + this.tempAuthKeyId + ", permAuthKeyId=" + this.permAuthKeyId + ", tempSessionId=" + this.tempSessionId + ", expiresAt=" + this.expiresAt + "}";
    }

    public static ImmutableBindAuthKeyInner of(long nonce, long tempAuthKeyId, long permAuthKeyId, long tempSessionId, int expiresAt) {
        return new ImmutableBindAuthKeyInner(nonce, tempAuthKeyId, permAuthKeyId, tempSessionId, expiresAt);
    }

    public static ImmutableBindAuthKeyInner copyOf(BindAuthKeyInner instance) {
        if (instance instanceof ImmutableBindAuthKeyInner) {
            return (ImmutableBindAuthKeyInner)instance;
        }
        return ImmutableBindAuthKeyInner.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_NONCE = 1L;
        private static final long INIT_BIT_TEMP_AUTH_KEY_ID = 2L;
        private static final long INIT_BIT_PERM_AUTH_KEY_ID = 4L;
        private static final long INIT_BIT_TEMP_SESSION_ID = 8L;
        private static final long INIT_BIT_EXPIRES_AT = 16L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 31L;
        private long optBits;
        private int identifier;
        private long nonce;
        private long tempAuthKeyId;
        private long permAuthKeyId;
        private long tempSessionId;
        private int expiresAt;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BindAuthKeyInner instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BindAuthKeyInner) {
                instance = (BindAuthKeyInner)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.permAuthKeyId(instance.permAuthKeyId());
                this.tempAuthKeyId(instance.tempAuthKeyId());
                this.nonce(instance.nonce());
                this.tempSessionId(instance.tempSessionId());
                this.expiresAt(instance.expiresAt());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder nonce(long nonce) {
            this.nonce = nonce;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder tempAuthKeyId(long tempAuthKeyId) {
            this.tempAuthKeyId = tempAuthKeyId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder permAuthKeyId(long permAuthKeyId) {
            this.permAuthKeyId = permAuthKeyId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder tempSessionId(long tempSessionId) {
            this.tempSessionId = tempSessionId;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder expiresAt(int expiresAt) {
            this.expiresAt = expiresAt;
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public ImmutableBindAuthKeyInner build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBindAuthKeyInner(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("nonce");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tempAuthKeyId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("permAuthKeyId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("tempSessionId");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("expiresAt");
            }
            return "Cannot build BindAuthKeyInner, some of required attributes are not set " + attributes;
        }
    }
}

