/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.DhGenFail;
import telegram4j.tl.mtproto.SetClientDHParamsAnswer;

public final class ImmutableDhGenFail
implements DhGenFail {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf newNonceHash3;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDhGenFail(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.newNonceHash3 = builder.newNonceHash3_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableDhGenFail(int identifier, ByteBuf nonce, ByteBuf serverNonce, ByteBuf newNonceHash3) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.newNonceHash3 = newNonceHash3;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DhGenFail.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf newNonceHash3() {
        return this.newNonceHash3.duplicate();
    }

    public final ImmutableDhGenFail withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDhGenFail(value, this.nonce, this.serverNonce, this.newNonceHash3);
    }

    public ImmutableDhGenFail withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableDhGenFail(this.identifier, newValue, this.serverNonce, this.newNonceHash3);
    }

    public ImmutableDhGenFail withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableDhGenFail(this.identifier, this.nonce, newValue, this.newNonceHash3);
    }

    public ImmutableDhGenFail withNewNonceHash3(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.newNonceHash3 == newValue) {
            return this;
        }
        return new ImmutableDhGenFail(this.identifier, this.nonce, this.serverNonce, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDhGenFail && this.equalTo(0, (ImmutableDhGenFail)another);
    }

    private boolean equalTo(int synthetic, ImmutableDhGenFail another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.newNonceHash3().equals((Object)another.newNonceHash3());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.newNonceHash3().hashCode();
        return h;
    }

    public String toString() {
        return "DhGenFail{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", newNonceHash3=" + ByteBufUtil.hexDump((ByteBuf)this.newNonceHash3) + "}";
    }

    public static ImmutableDhGenFail copyOf(DhGenFail instance) {
        if (instance instanceof ImmutableDhGenFail) {
            return (ImmutableDhGenFail)instance;
        }
        return ImmutableDhGenFail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf newNonceHash3_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetClientDHParamsAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(DhGenFail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetClientDHParamsAnswer) {
                instance = (SetClientDHParamsAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 2L;
                }
            }
            if (object instanceof DhGenFail) {
                instance = (DhGenFail)object;
                this.newNonceHash3(instance.newNonceHash3());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 4L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder newNonceHash3(ByteBuf value) {
            this.newNonceHash3_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableDhGenFail build() {
            return new ImmutableDhGenFail(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf newNonceHash3_build() {
            return Objects.requireNonNull(this.newNonceHash3_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDhGenFail.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build DhGenFail, attribute initializers form cycle " + attributes;
        }
    }
}

