/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.DhGenRetry;
import telegram4j.tl.mtproto.SetClientDHParamsAnswer;

public final class ImmutableDhGenRetry
implements DhGenRetry {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf newNonceHash2;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableDhGenRetry(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.newNonceHash2 = builder.newNonceHash2_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableDhGenRetry(int identifier, ByteBuf nonce, ByteBuf serverNonce, ByteBuf newNonceHash2) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.newNonceHash2 = newNonceHash2;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return DhGenRetry.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf newNonceHash2() {
        return this.newNonceHash2.duplicate();
    }

    public final ImmutableDhGenRetry withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableDhGenRetry(value, this.nonce, this.serverNonce, this.newNonceHash2);
    }

    public ImmutableDhGenRetry withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableDhGenRetry(this.identifier, newValue, this.serverNonce, this.newNonceHash2);
    }

    public ImmutableDhGenRetry withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableDhGenRetry(this.identifier, this.nonce, newValue, this.newNonceHash2);
    }

    public ImmutableDhGenRetry withNewNonceHash2(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.newNonceHash2 == newValue) {
            return this;
        }
        return new ImmutableDhGenRetry(this.identifier, this.nonce, this.serverNonce, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableDhGenRetry && this.equalTo(0, (ImmutableDhGenRetry)another);
    }

    private boolean equalTo(int synthetic, ImmutableDhGenRetry another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.newNonceHash2().equals((Object)another.newNonceHash2());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.newNonceHash2().hashCode();
        return h;
    }

    public String toString() {
        return "DhGenRetry{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", newNonceHash2=" + ByteBufUtil.hexDump((ByteBuf)this.newNonceHash2) + "}";
    }

    public static ImmutableDhGenRetry copyOf(DhGenRetry instance) {
        if (instance instanceof ImmutableDhGenRetry) {
            return (ImmutableDhGenRetry)instance;
        }
        return ImmutableDhGenRetry.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf newNonceHash2_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(DhGenRetry instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SetClientDHParamsAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SetClientDHParamsAnswer instance;
            long bits = 0L;
            if (object instanceof DhGenRetry) {
                instance = (DhGenRetry)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.newNonceHash2(instance.newNonceHash2());
                if ((bits & 2L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 4L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof SetClientDHParamsAnswer) {
                instance = (SetClientDHParamsAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 2L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder newNonceHash2(ByteBuf value) {
            this.newNonceHash2_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableDhGenRetry build() {
            return new ImmutableDhGenRetry(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf newNonceHash2_build() {
            return Objects.requireNonNull(this.newNonceHash2_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableDhGenRetry.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build DhGenRetry, attribute initializers form cycle " + attributes;
        }
    }
}

