/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.FutureSalt;

public final class ImmutableFutureSalt
implements FutureSalt {
    private final int identifier;
    private final int validSince;
    private final int validUntil;
    private final long salt;

    private ImmutableFutureSalt(int validSince, int validUntil, long salt) {
        this.validSince = validSince;
        this.validUntil = validUntil;
        this.salt = salt;
        this.identifier = FutureSalt.super.identifier();
    }

    private ImmutableFutureSalt(Builder builder) {
        this.validSince = builder.validSince;
        this.validUntil = builder.validUntil;
        this.salt = builder.salt;
        this.identifier = builder.identifierIsSet() ? builder.identifier : FutureSalt.super.identifier();
    }

    private ImmutableFutureSalt(int identifier, int validSince, int validUntil, long salt) {
        this.identifier = identifier;
        this.validSince = validSince;
        this.validUntil = validUntil;
        this.salt = salt;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int validSince() {
        return this.validSince;
    }

    @Override
    public int validUntil() {
        return this.validUntil;
    }

    @Override
    public long salt() {
        return this.salt;
    }

    public final ImmutableFutureSalt withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFutureSalt(value, this.validSince, this.validUntil, this.salt);
    }

    public final ImmutableFutureSalt withValidSince(int value) {
        if (this.validSince == value) {
            return this;
        }
        return new ImmutableFutureSalt(this.identifier, value, this.validUntil, this.salt);
    }

    public final ImmutableFutureSalt withValidUntil(int value) {
        if (this.validUntil == value) {
            return this;
        }
        return new ImmutableFutureSalt(this.identifier, this.validSince, value, this.salt);
    }

    public final ImmutableFutureSalt withSalt(long value) {
        if (this.salt == value) {
            return this;
        }
        return new ImmutableFutureSalt(this.identifier, this.validSince, this.validUntil, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFutureSalt && this.equalTo(0, (ImmutableFutureSalt)another);
    }

    private boolean equalTo(int synthetic, ImmutableFutureSalt another) {
        return this.identifier == another.identifier && this.validSince == another.validSince && this.validUntil == another.validUntil && this.salt == another.salt;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.validSince;
        h += (h << 5) + this.validUntil;
        h += (h << 5) + Long.hashCode(this.salt);
        return h;
    }

    public String toString() {
        return "FutureSalt{identifier=" + this.identifier + ", validSince=" + this.validSince + ", validUntil=" + this.validUntil + ", salt=" + this.salt + "}";
    }

    public static ImmutableFutureSalt of(int validSince, int validUntil, long salt) {
        return new ImmutableFutureSalt(validSince, validUntil, salt);
    }

    public static ImmutableFutureSalt copyOf(FutureSalt instance) {
        if (instance instanceof ImmutableFutureSalt) {
            return (ImmutableFutureSalt)instance;
        }
        return ImmutableFutureSalt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_VALID_SINCE = 1L;
        private static final long INIT_BIT_VALID_UNTIL = 2L;
        private static final long INIT_BIT_SALT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int validSince;
        private int validUntil;
        private long salt;

        private Builder() {
        }

        public final Builder from(FutureSalt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FutureSalt instance;
            long bits = 0L;
            if (object instanceof FutureSalt) {
                instance = (FutureSalt)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.validUntil(instance.validUntil());
                this.validSince(instance.validSince());
                this.salt(instance.salt());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder validSince(int validSince) {
            this.validSince = validSince;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder validUntil(int validUntil) {
            this.validUntil = validUntil;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder salt(long salt) {
            this.salt = salt;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableFutureSalt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFutureSalt(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("validSince");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("validUntil");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("salt");
            }
            return "Cannot build FutureSalt, some of required attributes are not set " + attributes;
        }
    }
}

