/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.FutureSalt;
import telegram4j.tl.mtproto.FutureSalts;

public final class ImmutableFutureSalts
implements FutureSalts {
    private final int identifier;
    private final long reqMsgId;
    private final int now;
    private final List<FutureSalt> salts;

    private ImmutableFutureSalts(long reqMsgId, int now) {
        this.reqMsgId = reqMsgId;
        this.now = now;
        this.salts = Collections.emptyList();
        this.identifier = FutureSalts.super.identifier();
    }

    private ImmutableFutureSalts(Builder builder) {
        this.reqMsgId = builder.reqMsgId;
        this.now = builder.now;
        this.salts = ImmutableFutureSalts.createUnmodifiableList(true, builder.salts);
        this.identifier = builder.identifierIsSet() ? builder.identifier : FutureSalts.super.identifier();
    }

    private ImmutableFutureSalts(int identifier, long reqMsgId, int now, List<FutureSalt> salts) {
        this.identifier = identifier;
        this.reqMsgId = reqMsgId;
        this.now = now;
        this.salts = salts;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long reqMsgId() {
        return this.reqMsgId;
    }

    @Override
    public int now() {
        return this.now;
    }

    @Override
    public List<FutureSalt> salts() {
        return this.salts;
    }

    public final ImmutableFutureSalts withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableFutureSalts(value, this.reqMsgId, this.now, this.salts);
    }

    public final ImmutableFutureSalts withReqMsgId(long value) {
        if (this.reqMsgId == value) {
            return this;
        }
        return new ImmutableFutureSalts(this.identifier, value, this.now, this.salts);
    }

    public final ImmutableFutureSalts withNow(int value) {
        if (this.now == value) {
            return this;
        }
        return new ImmutableFutureSalts(this.identifier, this.reqMsgId, value, this.salts);
    }

    public final ImmutableFutureSalts withSalts(FutureSalt ... elements) {
        List<FutureSalt> newValue = ImmutableFutureSalts.createUnmodifiableList(false, ImmutableFutureSalts.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFutureSalts(this.identifier, this.reqMsgId, this.now, newValue);
    }

    public final ImmutableFutureSalts withSalts(Iterable<? extends FutureSalt> elements) {
        if (this.salts == elements) {
            return this;
        }
        List<FutureSalt> newValue = ImmutableFutureSalts.createUnmodifiableList(false, ImmutableFutureSalts.createSafeList(elements, true, false));
        return new ImmutableFutureSalts(this.identifier, this.reqMsgId, this.now, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFutureSalts && this.equalTo(0, (ImmutableFutureSalts)another);
    }

    private boolean equalTo(int synthetic, ImmutableFutureSalts another) {
        return this.identifier == another.identifier && this.reqMsgId == another.reqMsgId && this.now == another.now && this.salts.equals(another.salts);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.reqMsgId);
        h += (h << 5) + this.now;
        h += (h << 5) + this.salts.hashCode();
        return h;
    }

    public String toString() {
        return "FutureSalts{identifier=" + this.identifier + ", reqMsgId=" + this.reqMsgId + ", now=" + this.now + ", salts=" + this.salts + "}";
    }

    public static ImmutableFutureSalts of(long reqMsgId, int now) {
        return new ImmutableFutureSalts(reqMsgId, now);
    }

    public static ImmutableFutureSalts copyOf(FutureSalts instance) {
        if (instance instanceof ImmutableFutureSalts) {
            return (ImmutableFutureSalts)instance;
        }
        return ImmutableFutureSalts.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_REQ_MSG_ID = 1L;
        private static final long INIT_BIT_NOW = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long reqMsgId;
        private int now;
        private List<FutureSalt> salts = new ArrayList<FutureSalt>();

        private Builder() {
        }

        public final Builder from(FutureSalts instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            FutureSalts instance;
            long bits = 0L;
            if (object instanceof FutureSalts) {
                instance = (FutureSalts)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.now(instance.now());
                this.reqMsgId(instance.reqMsgId());
                this.addAllSalts(instance.salts());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder reqMsgId(long reqMsgId) {
            this.reqMsgId = reqMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder now(int now) {
            this.now = now;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addSalt(FutureSalt element) {
            this.salts.add(Objects.requireNonNull(element, "salts element"));
            return this;
        }

        public final Builder addSalts(FutureSalt ... elements) {
            for (FutureSalt element : elements) {
                this.salts.add(Objects.requireNonNull(element, "salts element"));
            }
            return this;
        }

        public final Builder salts(Iterable<? extends FutureSalt> elements) {
            this.salts.clear();
            return this.addAllSalts(elements);
        }

        public final Builder addAllSalts(Iterable<? extends FutureSalt> elements) {
            for (FutureSalt futureSalt : elements) {
                this.salts.add(Objects.requireNonNull(futureSalt, "salts element"));
            }
            return this;
        }

        public ImmutableFutureSalts build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFutureSalts(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reqMsgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("now");
            }
            return "Cannot build FutureSalts, some of required attributes are not set " + attributes;
        }
    }
}

