/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.GzipPacked;

public final class ImmutableGzipPacked
implements GzipPacked {
    private final int identifier;
    private final ByteBuf packedData;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGzipPacked(Builder builder) {
        this.packedData = builder.packedData_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableGzipPacked(int identifier, ByteBuf packedData) {
        this.identifier = identifier;
        this.packedData = packedData;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return GzipPacked.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf packedData() {
        return this.packedData.duplicate();
    }

    public final ImmutableGzipPacked withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGzipPacked(value, this.packedData);
    }

    public ImmutableGzipPacked withPackedData(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.packedData == newValue) {
            return this;
        }
        return new ImmutableGzipPacked(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGzipPacked && this.equalTo(0, (ImmutableGzipPacked)another);
    }

    private boolean equalTo(int synthetic, ImmutableGzipPacked another) {
        return this.identifier == another.identifier && this.packedData().equals((Object)another.packedData());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.packedData().hashCode();
        return h;
    }

    public String toString() {
        return "GzipPacked{identifier=" + this.identifier + ", packedData=" + ByteBufUtil.hexDump((ByteBuf)this.packedData) + "}";
    }

    public static ImmutableGzipPacked copyOf(GzipPacked instance) {
        if (instance instanceof ImmutableGzipPacked) {
            return (ImmutableGzipPacked)instance;
        }
        return ImmutableGzipPacked.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf packedData_value = null;
        private int identifier;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GzipPacked instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof GzipPacked) {
                instance = (GzipPacked)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.packedData(instance.packedData());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder packedData(ByteBuf value) {
            this.packedData_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableGzipPacked build() {
            return new ImmutableGzipPacked(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf packedData_build() {
            return Objects.requireNonNull(this.packedData_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableGzipPacked.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build GzipPacked, attribute initializers form cycle " + attributes;
        }
    }
}

