/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.Message;

public final class ImmutableMessage
implements Message {
    private final int identifier;
    private final long msgId;
    private final int seqno;
    private final int bytes;
    private final Object body;

    private ImmutableMessage(long msgId, int seqno, int bytes, Object body) {
        this.msgId = msgId;
        this.seqno = seqno;
        this.bytes = bytes;
        this.body = Objects.requireNonNull(body, "body");
        this.identifier = Message.super.identifier();
    }

    private ImmutableMessage(Builder builder) {
        this.msgId = builder.msgId;
        this.seqno = builder.seqno;
        this.bytes = builder.bytes;
        this.body = builder.body;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Message.super.identifier();
    }

    private ImmutableMessage(int identifier, long msgId, int seqno, int bytes, Object body) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.seqno = seqno;
        this.bytes = bytes;
        this.body = body;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long msgId() {
        return this.msgId;
    }

    @Override
    public int seqno() {
        return this.seqno;
    }

    @Override
    public int bytes() {
        return this.bytes;
    }

    @Override
    public Object body() {
        return this.body;
    }

    public final ImmutableMessage withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessage(value, this.msgId, this.seqno, this.bytes, this.body);
    }

    public final ImmutableMessage withMsgId(long value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableMessage(this.identifier, value, this.seqno, this.bytes, this.body);
    }

    public final ImmutableMessage withSeqno(int value) {
        if (this.seqno == value) {
            return this;
        }
        return new ImmutableMessage(this.identifier, this.msgId, value, this.bytes, this.body);
    }

    public final ImmutableMessage withBytes(int value) {
        if (this.bytes == value) {
            return this;
        }
        return new ImmutableMessage(this.identifier, this.msgId, this.seqno, value, this.body);
    }

    public final ImmutableMessage withBody(Object value) {
        if (this.body == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "body");
        return new ImmutableMessage(this.identifier, this.msgId, this.seqno, this.bytes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessage && this.equalTo(0, (ImmutableMessage)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessage another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.seqno == another.seqno && this.bytes == another.bytes && this.body.equals(another.body);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.msgId);
        h += (h << 5) + this.seqno;
        h += (h << 5) + this.bytes;
        h += (h << 5) + this.body.hashCode();
        return h;
    }

    public String toString() {
        return "Message{identifier=" + this.identifier + ", msgId=" + this.msgId + ", seqno=" + this.seqno + ", bytes=" + this.bytes + ", body=" + this.body + "}";
    }

    public static ImmutableMessage of(long msgId, int seqno, int bytes, Object body) {
        return new ImmutableMessage(msgId, seqno, bytes, body);
    }

    public static ImmutableMessage copyOf(Message instance) {
        if (instance instanceof ImmutableMessage) {
            return (ImmutableMessage)instance;
        }
        return ImmutableMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_SEQNO = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private static final long INIT_BIT_BODY = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long msgId;
        private int seqno;
        private int bytes;
        private Object body;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Message instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Message) {
                instance = (Message)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.seqno(instance.seqno());
                this.body(instance.body());
                this.bytes(instance.bytes());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(long msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seqno(int seqno) {
            this.seqno = seqno;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bytes(int bytes) {
            this.bytes = bytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder body(Object body) {
            this.body = Objects.requireNonNull(body, "body");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessage(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seqno");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("body");
            }
            return "Cannot build Message, some of required attributes are not set " + attributes;
        }
    }
}

