/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.Message;
import telegram4j.tl.mtproto.MessageContainer;

public final class ImmutableMessageContainer
implements MessageContainer {
    private final int identifier;
    private final List<Message> messages;

    private ImmutableMessageContainer(Builder builder) {
        this.messages = ImmutableMessageContainer.createUnmodifiableList(true, builder.messages);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageContainer.super.identifier();
    }

    private ImmutableMessageContainer(int identifier, List<Message> messages) {
        this.identifier = identifier;
        this.messages = messages;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Message> messages() {
        return this.messages;
    }

    public final ImmutableMessageContainer withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageContainer(value, this.messages);
    }

    public final ImmutableMessageContainer withMessages(Message ... elements) {
        List<Message> newValue = ImmutableMessageContainer.createUnmodifiableList(false, ImmutableMessageContainer.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMessageContainer(this.identifier, newValue);
    }

    public final ImmutableMessageContainer withMessages(Iterable<? extends Message> elements) {
        if (this.messages == elements) {
            return this;
        }
        List<Message> newValue = ImmutableMessageContainer.createUnmodifiableList(false, ImmutableMessageContainer.createSafeList(elements, true, false));
        return new ImmutableMessageContainer(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageContainer && this.equalTo(0, (ImmutableMessageContainer)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageContainer another) {
        return this.identifier == another.identifier && this.messages.equals(another.messages);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.messages.hashCode();
        return h;
    }

    public String toString() {
        return "MessageContainer{identifier=" + this.identifier + ", messages=" + this.messages + "}";
    }

    public static ImmutableMessageContainer copyOf(MessageContainer instance) {
        if (instance instanceof ImmutableMessageContainer) {
            return (ImmutableMessageContainer)instance;
        }
        return ImmutableMessageContainer.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Message> messages = new ArrayList<Message>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageContainer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageContainer) {
                instance = (MessageContainer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMessages(instance.messages());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMessage(Message element) {
            this.messages.add(Objects.requireNonNull(element, "messages element"));
            return this;
        }

        public final Builder addMessages(Message ... elements) {
            for (Message element : elements) {
                this.messages.add(Objects.requireNonNull(element, "messages element"));
            }
            return this;
        }

        public final Builder messages(Iterable<? extends Message> elements) {
            this.messages.clear();
            return this.addAllMessages(elements);
        }

        public final Builder addAllMessages(Iterable<? extends Message> elements) {
            for (Message message : elements) {
                this.messages.add(Objects.requireNonNull(message, "messages element"));
            }
            return this;
        }

        public ImmutableMessageContainer build() {
            return new ImmutableMessageContainer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

