/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.Message;
import telegram4j.tl.mtproto.MessageCopy;

public final class ImmutableMessageCopy
implements MessageCopy {
    private final int identifier;
    private final Message origMessage;

    private ImmutableMessageCopy(Message origMessage) {
        this.origMessage = Objects.requireNonNull(origMessage, "origMessage");
        this.identifier = MessageCopy.super.identifier();
    }

    private ImmutableMessageCopy(Builder builder) {
        this.origMessage = builder.origMessage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : MessageCopy.super.identifier();
    }

    private ImmutableMessageCopy(int identifier, Message origMessage) {
        this.identifier = identifier;
        this.origMessage = origMessage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Message origMessage() {
        return this.origMessage;
    }

    public final ImmutableMessageCopy withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMessageCopy(value, this.origMessage);
    }

    public final ImmutableMessageCopy withOrigMessage(Message value) {
        if (this.origMessage == value) {
            return this;
        }
        Message newValue = Objects.requireNonNull(value, "origMessage");
        return new ImmutableMessageCopy(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMessageCopy && this.equalTo(0, (ImmutableMessageCopy)another);
    }

    private boolean equalTo(int synthetic, ImmutableMessageCopy another) {
        return this.identifier == another.identifier && this.origMessage.equals(another.origMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.origMessage.hashCode();
        return h;
    }

    public String toString() {
        return "MessageCopy{identifier=" + this.identifier + ", origMessage=" + this.origMessage + "}";
    }

    public static ImmutableMessageCopy of(Message origMessage) {
        return new ImmutableMessageCopy(origMessage);
    }

    public static ImmutableMessageCopy copyOf(MessageCopy instance) {
        if (instance instanceof ImmutableMessageCopy) {
            return (ImmutableMessageCopy)instance;
        }
        return ImmutableMessageCopy.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ORIG_MESSAGE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Message origMessage;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MessageCopy instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MessageCopy) {
                instance = (MessageCopy)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.origMessage(instance.origMessage());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder origMessage(Message origMessage) {
            this.origMessage = Objects.requireNonNull(origMessage, "origMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableMessageCopy build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMessageCopy(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origMessage");
            }
            return "Cannot build MessageCopy, some of required attributes are not set " + attributes;
        }
    }
}

