/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.RpcMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.MsgResendReq;

public final class ImmutableMsgResendReq
implements MsgResendReq {
    private final int identifier;
    private final List<Long> msgIds;

    private ImmutableMsgResendReq(Builder builder) {
        this.msgIds = ImmutableMsgResendReq.createUnmodifiableList(true, builder.msgIds);
        this.identifier = builder.identifierIsSet() ? builder.identifier : MsgResendReq.super.identifier();
    }

    private ImmutableMsgResendReq(int identifier, List<Long> msgIds) {
        this.identifier = identifier;
        this.msgIds = msgIds;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> msgIds() {
        return this.msgIds;
    }

    public final ImmutableMsgResendReq withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMsgResendReq(value, this.msgIds);
    }

    public final ImmutableMsgResendReq withMsgIds(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableMsgResendReq.createUnmodifiableList(false, wrappedList);
        return new ImmutableMsgResendReq(this.identifier, newValue);
    }

    public final ImmutableMsgResendReq withMsgIds(Iterable<Long> elements) {
        if (this.msgIds == elements) {
            return this;
        }
        List<Long> newValue = ImmutableMsgResendReq.createUnmodifiableList(false, ImmutableMsgResendReq.createSafeList(elements, true, false));
        return new ImmutableMsgResendReq(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMsgResendReq && this.equalTo(0, (ImmutableMsgResendReq)another);
    }

    private boolean equalTo(int synthetic, ImmutableMsgResendReq another) {
        return this.identifier == another.identifier && this.msgIds.equals(another.msgIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.msgIds.hashCode();
        return h;
    }

    public String toString() {
        return "MsgResendReq{identifier=" + this.identifier + ", msgIds=" + this.msgIds + "}";
    }

    public static ImmutableMsgResendReq copyOf(MsgResendReq instance) {
        if (instance instanceof ImmutableMsgResendReq) {
            return (ImmutableMsgResendReq)instance;
        }
        return ImmutableMsgResendReq.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Long> msgIds = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(RpcMethod instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MsgResendReq instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcMethod instance;
            long bits = 0L;
            if (object instanceof RpcMethod) {
                instance = (RpcMethod)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MsgResendReq) {
                instance = (MsgResendReq)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMsgIds(instance.msgIds());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMsgId(long element) {
            this.msgIds.add(element);
            return this;
        }

        public final Builder addMsgIds(long ... elements) {
            for (long element : elements) {
                this.msgIds.add(element);
            }
            return this;
        }

        public final Builder msgIds(Iterable<Long> elements) {
            this.msgIds.clear();
            return this.addAllMsgIds(elements);
        }

        public final Builder addAllMsgIds(Iterable<Long> elements) {
            for (Long element : elements) {
                this.msgIds.add(Objects.requireNonNull(element, "msgIds element"));
            }
            return this;
        }

        public ImmutableMsgResendReq build() {
            return new ImmutableMsgResendReq(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

