/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.RpcMethod;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.MsgsAllInfo;

public final class ImmutableMsgsAllInfo
implements MsgsAllInfo {
    private final int identifier;
    private final List<Long> msgIds;
    private final ByteBuf info;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMsgsAllInfo(Builder builder) {
        this.msgIds = ImmutableMsgsAllInfo.createUnmodifiableList(true, builder.msgIds);
        this.info = builder.info_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableMsgsAllInfo(int identifier, List<Long> msgIds, ByteBuf info) {
        this.identifier = identifier;
        this.msgIds = msgIds;
        this.info = info;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MsgsAllInfo.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public List<Long> msgIds() {
        return this.msgIds;
    }

    @Override
    public ByteBuf info() {
        return this.info.duplicate();
    }

    public final ImmutableMsgsAllInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMsgsAllInfo(value, this.msgIds, this.info);
    }

    public final ImmutableMsgsAllInfo withMsgIds(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableMsgsAllInfo.createUnmodifiableList(false, wrappedList);
        return new ImmutableMsgsAllInfo(this.identifier, newValue, this.info);
    }

    public final ImmutableMsgsAllInfo withMsgIds(Iterable<Long> elements) {
        if (this.msgIds == elements) {
            return this;
        }
        List<Long> newValue = ImmutableMsgsAllInfo.createUnmodifiableList(false, ImmutableMsgsAllInfo.createSafeList(elements, true, false));
        return new ImmutableMsgsAllInfo(this.identifier, newValue, this.info);
    }

    public ImmutableMsgsAllInfo withInfo(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.info == newValue) {
            return this;
        }
        return new ImmutableMsgsAllInfo(this.identifier, this.msgIds, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMsgsAllInfo && this.equalTo(0, (ImmutableMsgsAllInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableMsgsAllInfo another) {
        return this.identifier == another.identifier && this.msgIds.equals(another.msgIds) && this.info().equals((Object)another.info());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.msgIds.hashCode();
        h += (h << 5) + this.info().hashCode();
        return h;
    }

    public String toString() {
        return "MsgsAllInfo{identifier=" + this.identifier + ", msgIds=" + this.msgIds + ", info=" + ByteBufUtil.hexDump((ByteBuf)this.info) + "}";
    }

    public static ImmutableMsgsAllInfo copyOf(MsgsAllInfo instance) {
        if (instance instanceof ImmutableMsgsAllInfo) {
            return (ImmutableMsgsAllInfo)instance;
        }
        return ImmutableMsgsAllInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf info_value = null;
        private int identifier;
        private List<Long> msgIds = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(RpcMethod instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MsgsAllInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcMethod instance;
            long bits = 0L;
            if (object instanceof RpcMethod) {
                instance = (RpcMethod)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MsgsAllInfo) {
                instance = (MsgsAllInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMsgIds(instance.msgIds());
                this.info(instance.info());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addMsgId(long element) {
            this.msgIds.add(element);
            return this;
        }

        public final Builder addMsgIds(long ... elements) {
            for (long element : elements) {
                this.msgIds.add(element);
            }
            return this;
        }

        public final Builder msgIds(Iterable<Long> elements) {
            this.msgIds.clear();
            return this.addAllMsgIds(elements);
        }

        public final Builder addAllMsgIds(Iterable<Long> elements) {
            for (Long element : elements) {
                this.msgIds.add(Objects.requireNonNull(element, "msgIds element"));
            }
            return this;
        }

        public Builder info(ByteBuf value) {
            this.info_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableMsgsAllInfo build() {
            return new ImmutableMsgsAllInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf info_build() {
            return Objects.requireNonNull(this.info_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMsgsAllInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build MsgsAllInfo, attribute initializers form cycle " + attributes;
        }
    }
}

