/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.RpcMethod;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.MsgsStateInfo;

public final class ImmutableMsgsStateInfo
implements MsgsStateInfo {
    private final int identifier;
    private final long reqMsgId;
    private final ByteBuf info;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMsgsStateInfo(long reqMsgId) {
        this.reqMsgId = reqMsgId;
        this.info = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableMsgsStateInfo(Builder builder) {
        this.reqMsgId = builder.reqMsgId;
        this.info = builder.info_build();
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableMsgsStateInfo(int identifier, long reqMsgId, ByteBuf info) {
        this.identifier = identifier;
        this.reqMsgId = reqMsgId;
        this.info = info;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return MsgsStateInfo.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public long reqMsgId() {
        return this.reqMsgId;
    }

    @Override
    public ByteBuf info() {
        return this.info.duplicate();
    }

    public final ImmutableMsgsStateInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableMsgsStateInfo(value, this.reqMsgId, this.info);
    }

    public final ImmutableMsgsStateInfo withReqMsgId(long value) {
        if (this.reqMsgId == value) {
            return this;
        }
        return new ImmutableMsgsStateInfo(this.identifier, value, this.info);
    }

    public ImmutableMsgsStateInfo withInfo(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.info == newValue) {
            return this;
        }
        return new ImmutableMsgsStateInfo(this.identifier, this.reqMsgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMsgsStateInfo && this.equalTo(0, (ImmutableMsgsStateInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableMsgsStateInfo another) {
        return this.identifier == another.identifier && this.reqMsgId == another.reqMsgId && this.info().equals((Object)another.info());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.reqMsgId);
        h += (h << 5) + this.info().hashCode();
        return h;
    }

    public String toString() {
        return "MsgsStateInfo{identifier=" + this.identifier + ", reqMsgId=" + this.reqMsgId + ", info=" + ByteBufUtil.hexDump((ByteBuf)this.info) + "}";
    }

    public static ImmutableMsgsStateInfo of(long reqMsgId) {
        return new ImmutableMsgsStateInfo(reqMsgId);
    }

    public static ImmutableMsgsStateInfo copyOf(MsgsStateInfo instance) {
        if (instance instanceof ImmutableMsgsStateInfo) {
            return (ImmutableMsgsStateInfo)instance;
        }
        return ImmutableMsgsStateInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REQ_MSG_ID = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf info_value = null;
        private int identifier;
        private long reqMsgId;

        private Builder() {
        }

        public final Builder from(RpcMethod instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MsgsStateInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcMethod instance;
            long bits = 0L;
            if (object instanceof RpcMethod) {
                instance = (RpcMethod)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MsgsStateInfo) {
                instance = (MsgsStateInfo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reqMsgId(instance.reqMsgId());
                this.info(instance.info());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder reqMsgId(long reqMsgId) {
            this.reqMsgId = reqMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder info(ByteBuf value) {
            this.info_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public ImmutableMsgsStateInfo build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMsgsStateInfo(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reqMsgId");
            }
            return "Cannot build MsgsStateInfo, some of required attributes are not set " + attributes;
        }

        private ByteBuf info_build() {
            return Objects.requireNonNull(this.info_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableMsgsStateInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build MsgsStateInfo, attribute initializers form cycle " + attributes;
        }
    }
}

