/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.NewSession;

public final class ImmutableNewSession
implements NewSession {
    private final int identifier;
    private final long firstMsgId;
    private final long uniqueId;
    private final long serverSalt;

    private ImmutableNewSession(long firstMsgId, long uniqueId, long serverSalt) {
        this.firstMsgId = firstMsgId;
        this.uniqueId = uniqueId;
        this.serverSalt = serverSalt;
        this.identifier = NewSession.super.identifier();
    }

    private ImmutableNewSession(Builder builder) {
        this.firstMsgId = builder.firstMsgId;
        this.uniqueId = builder.uniqueId;
        this.serverSalt = builder.serverSalt;
        this.identifier = builder.identifierIsSet() ? builder.identifier : NewSession.super.identifier();
    }

    private ImmutableNewSession(int identifier, long firstMsgId, long uniqueId, long serverSalt) {
        this.identifier = identifier;
        this.firstMsgId = firstMsgId;
        this.uniqueId = uniqueId;
        this.serverSalt = serverSalt;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long firstMsgId() {
        return this.firstMsgId;
    }

    @Override
    public long uniqueId() {
        return this.uniqueId;
    }

    @Override
    public long serverSalt() {
        return this.serverSalt;
    }

    public final ImmutableNewSession withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableNewSession(value, this.firstMsgId, this.uniqueId, this.serverSalt);
    }

    public final ImmutableNewSession withFirstMsgId(long value) {
        if (this.firstMsgId == value) {
            return this;
        }
        return new ImmutableNewSession(this.identifier, value, this.uniqueId, this.serverSalt);
    }

    public final ImmutableNewSession withUniqueId(long value) {
        if (this.uniqueId == value) {
            return this;
        }
        return new ImmutableNewSession(this.identifier, this.firstMsgId, value, this.serverSalt);
    }

    public final ImmutableNewSession withServerSalt(long value) {
        if (this.serverSalt == value) {
            return this;
        }
        return new ImmutableNewSession(this.identifier, this.firstMsgId, this.uniqueId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNewSession && this.equalTo(0, (ImmutableNewSession)another);
    }

    private boolean equalTo(int synthetic, ImmutableNewSession another) {
        return this.identifier == another.identifier && this.firstMsgId == another.firstMsgId && this.uniqueId == another.uniqueId && this.serverSalt == another.serverSalt;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.firstMsgId);
        h += (h << 5) + Long.hashCode(this.uniqueId);
        h += (h << 5) + Long.hashCode(this.serverSalt);
        return h;
    }

    public String toString() {
        return "NewSession{identifier=" + this.identifier + ", firstMsgId=" + this.firstMsgId + ", uniqueId=" + this.uniqueId + ", serverSalt=" + this.serverSalt + "}";
    }

    public static ImmutableNewSession of(long firstMsgId, long uniqueId, long serverSalt) {
        return new ImmutableNewSession(firstMsgId, uniqueId, serverSalt);
    }

    public static ImmutableNewSession copyOf(NewSession instance) {
        if (instance instanceof ImmutableNewSession) {
            return (ImmutableNewSession)instance;
        }
        return ImmutableNewSession.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_FIRST_MSG_ID = 1L;
        private static final long INIT_BIT_UNIQUE_ID = 2L;
        private static final long INIT_BIT_SERVER_SALT = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long firstMsgId;
        private long uniqueId;
        private long serverSalt;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(NewSession instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof NewSession) {
                instance = (NewSession)object;
                this.firstMsgId(instance.firstMsgId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.serverSalt(instance.serverSalt());
                this.uniqueId(instance.uniqueId());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder firstMsgId(long firstMsgId) {
            this.firstMsgId = firstMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder uniqueId(long uniqueId) {
            this.uniqueId = uniqueId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder serverSalt(long serverSalt) {
            this.serverSalt = serverSalt;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableNewSession build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNewSession(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("firstMsgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("uniqueId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("serverSalt");
            }
            return "Cannot build NewSession, some of required attributes are not set " + attributes;
        }
    }
}

