/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.PQInnerData;
import telegram4j.tl.mtproto.PQInnerDataDc;

public final class ImmutablePQInnerDataDc
implements PQInnerDataDc {
    private final int identifier;
    private final ByteBuf pq;
    private final ByteBuf p;
    private final ByteBuf q;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf newNonce;
    private final int dc;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePQInnerDataDc(int dc) {
        this.dc = dc;
        this.pq = null;
        this.p = null;
        this.q = null;
        this.nonce = null;
        this.serverNonce = null;
        this.newNonce = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePQInnerDataDc(Builder builder) {
        this.pq = builder.pq_build();
        this.p = builder.p_build();
        this.q = builder.q_build();
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.newNonce = builder.newNonce_build();
        this.dc = builder.dc;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutablePQInnerDataDc(int identifier, ByteBuf pq, ByteBuf p, ByteBuf q, ByteBuf nonce, ByteBuf serverNonce, ByteBuf newNonce, int dc) {
        this.identifier = identifier;
        this.pq = pq;
        this.p = p;
        this.q = q;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.newNonce = newNonce;
        this.dc = dc;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PQInnerDataDc.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf pq() {
        return this.pq.duplicate();
    }

    @Override
    public ByteBuf p() {
        return this.p.duplicate();
    }

    @Override
    public ByteBuf q() {
        return this.q.duplicate();
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf newNonce() {
        return this.newNonce.duplicate();
    }

    @Override
    public int dc() {
        return this.dc;
    }

    public final ImmutablePQInnerDataDc withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePQInnerDataDc(value, this.pq, this.p, this.q, this.nonce, this.serverNonce, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withPq(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.pq == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, newValue, this.p, this.q, this.nonce, this.serverNonce, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withP(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.p == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, newValue, this.q, this.nonce, this.serverNonce, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withQ(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.q == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, this.p, newValue, this.nonce, this.serverNonce, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, this.p, this.q, newValue, this.serverNonce, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, this.p, this.q, this.nonce, newValue, this.newNonce, this.dc);
    }

    public ImmutablePQInnerDataDc withNewNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.newNonce == newValue) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, this.p, this.q, this.nonce, this.serverNonce, newValue, this.dc);
    }

    public final ImmutablePQInnerDataDc withDc(int value) {
        if (this.dc == value) {
            return this;
        }
        return new ImmutablePQInnerDataDc(this.identifier, this.pq, this.p, this.q, this.nonce, this.serverNonce, this.newNonce, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePQInnerDataDc && this.equalTo(0, (ImmutablePQInnerDataDc)another);
    }

    private boolean equalTo(int synthetic, ImmutablePQInnerDataDc another) {
        return this.identifier == another.identifier && this.pq().equals((Object)another.pq()) && this.p().equals((Object)another.p()) && this.q().equals((Object)another.q()) && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.newNonce().equals((Object)another.newNonce()) && this.dc == another.dc;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.pq().hashCode();
        h += (h << 5) + this.p().hashCode();
        h += (h << 5) + this.q().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.newNonce().hashCode();
        h += (h << 5) + this.dc;
        return h;
    }

    public String toString() {
        return "PQInnerDataDc{identifier=" + this.identifier + ", pq=" + ByteBufUtil.hexDump((ByteBuf)this.pq) + ", p=" + ByteBufUtil.hexDump((ByteBuf)this.p) + ", q=" + ByteBufUtil.hexDump((ByteBuf)this.q) + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", newNonce=" + ByteBufUtil.hexDump((ByteBuf)this.newNonce) + ", dc=" + this.dc + "}";
    }

    public static ImmutablePQInnerDataDc of(int dc) {
        return new ImmutablePQInnerDataDc(dc);
    }

    public static ImmutablePQInnerDataDc copyOf(PQInnerDataDc instance) {
        if (instance instanceof ImmutablePQInnerDataDc) {
            return (ImmutablePQInnerDataDc)instance;
        }
        return ImmutablePQInnerDataDc.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_DC = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private ByteBuf pq_value = null;
        private ByteBuf p_value = null;
        private ByteBuf q_value = null;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf newNonce_value = null;
        private int identifier;
        private int dc;

        private Builder() {
        }

        public final Builder from(PQInnerDataDc instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PQInnerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            PQInnerData instance;
            long bits = 0L;
            if (object instanceof PQInnerDataDc) {
                instance = (PQInnerDataDc)object;
                if ((bits & 1L) == 0L) {
                    this.p(instance.p());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.pq(instance.pq());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.q(instance.q());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.newNonce(instance.newNonce());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.dc(instance.dc());
                    bits |= 0x80L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
            if (object instanceof PQInnerData) {
                instance = (PQInnerData)object;
                if ((bits & 1L) == 0L) {
                    this.p(instance.p());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.pq(instance.pq());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.q(instance.q());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.newNonce(instance.newNonce());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.serverNonce(instance.serverNonce());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.nonce(instance.nonce());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.dc(instance.dc());
                    bits |= 0x80L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 2L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 2L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder pq(ByteBuf value) {
            this.pq_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder p(ByteBuf value) {
            this.p_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder q(ByteBuf value) {
            this.q_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder newNonce(ByteBuf value) {
            this.newNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder dc(int dc) {
            this.dc = dc;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePQInnerDataDc build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePQInnerDataDc(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("dc");
            }
            return "Cannot build PQInnerDataDc, some of required attributes are not set " + attributes;
        }

        private ByteBuf pq_build() {
            return Objects.requireNonNull(this.pq_value);
        }

        private ByteBuf p_build() {
            return Objects.requireNonNull(this.p_value);
        }

        private ByteBuf q_build() {
            return Objects.requireNonNull(this.q_value);
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf newNonce_build() {
            return Objects.requireNonNull(this.newNonce_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePQInnerDataDc.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build PQInnerDataDc, attribute initializers form cycle " + attributes;
        }
    }
}

