/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.Pong;

public final class ImmutablePong
implements Pong {
    private final int identifier;
    private final long msgId;
    private final long pingId;

    private ImmutablePong(long msgId, long pingId) {
        this.msgId = msgId;
        this.pingId = pingId;
        this.identifier = Pong.super.identifier();
    }

    private ImmutablePong(Builder builder) {
        this.msgId = builder.msgId;
        this.pingId = builder.pingId;
        this.identifier = builder.identifierIsSet() ? builder.identifier : Pong.super.identifier();
    }

    private ImmutablePong(int identifier, long msgId, long pingId) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.pingId = pingId;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long msgId() {
        return this.msgId;
    }

    @Override
    public long pingId() {
        return this.pingId;
    }

    public final ImmutablePong withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePong(value, this.msgId, this.pingId);
    }

    public final ImmutablePong withMsgId(long value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutablePong(this.identifier, value, this.pingId);
    }

    public final ImmutablePong withPingId(long value) {
        if (this.pingId == value) {
            return this;
        }
        return new ImmutablePong(this.identifier, this.msgId, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePong && this.equalTo(0, (ImmutablePong)another);
    }

    private boolean equalTo(int synthetic, ImmutablePong another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.pingId == another.pingId;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.msgId);
        h += (h << 5) + Long.hashCode(this.pingId);
        return h;
    }

    public String toString() {
        return "Pong{identifier=" + this.identifier + ", msgId=" + this.msgId + ", pingId=" + this.pingId + "}";
    }

    public static ImmutablePong of(long msgId, long pingId) {
        return new ImmutablePong(msgId, pingId);
    }

    public static ImmutablePong copyOf(Pong instance) {
        if (instance instanceof ImmutablePong) {
            return (ImmutablePong)instance;
        }
        return ImmutablePong.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_PING_ID = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long msgId;
        private long pingId;

        private Builder() {
        }

        public final Builder from(Pong instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Pong instance;
            long bits = 0L;
            if (object instanceof Pong) {
                instance = (Pong)object;
                this.pingId(instance.pingId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(long msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder pingId(long pingId) {
            this.pingId = pingId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutablePong build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePong(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pingId");
            }
            return "Cannot build Pong, some of required attributes are not set " + attributes;
        }
    }
}

