/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.ResPQ;

public final class ImmutableResPQ
implements ResPQ {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final ByteBuf pq;
    private final List<Long> serverPublicKeyFingerprints;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableResPQ(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.pq = builder.pq_build();
        this.serverPublicKeyFingerprints = ImmutableResPQ.createUnmodifiableList(true, builder.serverPublicKeyFingerprints);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableResPQ(int identifier, ByteBuf nonce, ByteBuf serverNonce, ByteBuf pq, List<Long> serverPublicKeyFingerprints) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.pq = pq;
        this.serverPublicKeyFingerprints = serverPublicKeyFingerprints;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ResPQ.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public ByteBuf pq() {
        return this.pq.duplicate();
    }

    @Override
    public List<Long> serverPublicKeyFingerprints() {
        return this.serverPublicKeyFingerprints;
    }

    public final ImmutableResPQ withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableResPQ(value, this.nonce, this.serverNonce, this.pq, this.serverPublicKeyFingerprints);
    }

    public ImmutableResPQ withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableResPQ(this.identifier, newValue, this.serverNonce, this.pq, this.serverPublicKeyFingerprints);
    }

    public ImmutableResPQ withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableResPQ(this.identifier, this.nonce, newValue, this.pq, this.serverPublicKeyFingerprints);
    }

    public ImmutableResPQ withPq(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.pq == newValue) {
            return this;
        }
        return new ImmutableResPQ(this.identifier, this.nonce, this.serverNonce, newValue, this.serverPublicKeyFingerprints);
    }

    public final ImmutableResPQ withServerPublicKeyFingerprints(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableResPQ.createUnmodifiableList(false, wrappedList);
        return new ImmutableResPQ(this.identifier, this.nonce, this.serverNonce, this.pq, newValue);
    }

    public final ImmutableResPQ withServerPublicKeyFingerprints(Iterable<Long> elements) {
        if (this.serverPublicKeyFingerprints == elements) {
            return this;
        }
        List<Long> newValue = ImmutableResPQ.createUnmodifiableList(false, ImmutableResPQ.createSafeList(elements, true, false));
        return new ImmutableResPQ(this.identifier, this.nonce, this.serverNonce, this.pq, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableResPQ && this.equalTo(0, (ImmutableResPQ)another);
    }

    private boolean equalTo(int synthetic, ImmutableResPQ another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.pq().equals((Object)another.pq()) && this.serverPublicKeyFingerprints.equals(another.serverPublicKeyFingerprints);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.pq().hashCode();
        h += (h << 5) + this.serverPublicKeyFingerprints.hashCode();
        return h;
    }

    public String toString() {
        return "ResPQ{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", pq=" + ByteBufUtil.hexDump((ByteBuf)this.pq) + ", serverPublicKeyFingerprints=" + this.serverPublicKeyFingerprints + "}";
    }

    public static ImmutableResPQ copyOf(ResPQ instance) {
        if (instance instanceof ImmutableResPQ) {
            return (ImmutableResPQ)instance;
        }
        return ImmutableResPQ.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf pq_value = null;
        private int identifier;
        private List<Long> serverPublicKeyFingerprints = new ArrayList<Long>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ResPQ instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ResPQ) {
                instance = (ResPQ)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.pq(instance.pq());
                this.addAllServerPublicKeyFingerprints(instance.serverPublicKeyFingerprints());
                this.serverNonce(instance.serverNonce());
                this.nonce(instance.nonce());
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder pq(ByteBuf value) {
            this.pq_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder addServerPublicKeyFingerprint(long element) {
            this.serverPublicKeyFingerprints.add(element);
            return this;
        }

        public final Builder addServerPublicKeyFingerprints(long ... elements) {
            for (long element : elements) {
                this.serverPublicKeyFingerprints.add(element);
            }
            return this;
        }

        public final Builder serverPublicKeyFingerprints(Iterable<Long> elements) {
            this.serverPublicKeyFingerprints.clear();
            return this.addAllServerPublicKeyFingerprints(elements);
        }

        public final Builder addAllServerPublicKeyFingerprints(Iterable<Long> elements) {
            for (Long element : elements) {
                this.serverPublicKeyFingerprints.add(Objects.requireNonNull(element, "serverPublicKeyFingerprints element"));
            }
            return this;
        }

        public ImmutableResPQ build() {
            return new ImmutableResPQ(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf pq_build() {
            return Objects.requireNonNull(this.pq_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableResPQ.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ResPQ, attribute initializers form cycle " + attributes;
        }
    }
}

