/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.RpcAnswerDropped;
import telegram4j.tl.mtproto.RpcDropAnswer;

public final class ImmutableRpcAnswerDropped
implements RpcAnswerDropped {
    private final int identifier;
    private final long msgId;
    private final int seqNo;
    private final int bytes;

    private ImmutableRpcAnswerDropped(long msgId, int seqNo, int bytes) {
        this.msgId = msgId;
        this.seqNo = seqNo;
        this.bytes = bytes;
        this.identifier = RpcAnswerDropped.super.identifier();
    }

    private ImmutableRpcAnswerDropped(Builder builder) {
        this.msgId = builder.msgId;
        this.seqNo = builder.seqNo;
        this.bytes = builder.bytes;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RpcAnswerDropped.super.identifier();
    }

    private ImmutableRpcAnswerDropped(int identifier, long msgId, int seqNo, int bytes) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.seqNo = seqNo;
        this.bytes = bytes;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long msgId() {
        return this.msgId;
    }

    @Override
    public int seqNo() {
        return this.seqNo;
    }

    @Override
    public int bytes() {
        return this.bytes;
    }

    public final ImmutableRpcAnswerDropped withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRpcAnswerDropped(value, this.msgId, this.seqNo, this.bytes);
    }

    public final ImmutableRpcAnswerDropped withMsgId(long value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableRpcAnswerDropped(this.identifier, value, this.seqNo, this.bytes);
    }

    public final ImmutableRpcAnswerDropped withSeqNo(int value) {
        if (this.seqNo == value) {
            return this;
        }
        return new ImmutableRpcAnswerDropped(this.identifier, this.msgId, value, this.bytes);
    }

    public final ImmutableRpcAnswerDropped withBytes(int value) {
        if (this.bytes == value) {
            return this;
        }
        return new ImmutableRpcAnswerDropped(this.identifier, this.msgId, this.seqNo, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRpcAnswerDropped && this.equalTo(0, (ImmutableRpcAnswerDropped)another);
    }

    private boolean equalTo(int synthetic, ImmutableRpcAnswerDropped another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.seqNo == another.seqNo && this.bytes == another.bytes;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.msgId);
        h += (h << 5) + this.seqNo;
        h += (h << 5) + this.bytes;
        return h;
    }

    public String toString() {
        return "RpcAnswerDropped{identifier=" + this.identifier + ", msgId=" + this.msgId + ", seqNo=" + this.seqNo + ", bytes=" + this.bytes + "}";
    }

    public static ImmutableRpcAnswerDropped of(long msgId, int seqNo, int bytes) {
        return new ImmutableRpcAnswerDropped(msgId, seqNo, bytes);
    }

    public static ImmutableRpcAnswerDropped copyOf(RpcAnswerDropped instance) {
        if (instance instanceof ImmutableRpcAnswerDropped) {
            return (ImmutableRpcAnswerDropped)instance;
        }
        return ImmutableRpcAnswerDropped.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_SEQ_NO = 2L;
        private static final long INIT_BIT_BYTES = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private long msgId;
        private int seqNo;
        private int bytes;

        private Builder() {
        }

        public final Builder from(RpcAnswerDropped instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RpcDropAnswer instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcDropAnswer instance;
            long bits = 0L;
            if (object instanceof RpcAnswerDropped) {
                instance = (RpcAnswerDropped)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.seqNo(instance.seqNo());
                this.bytes(instance.bytes());
            }
            if (object instanceof RpcDropAnswer) {
                instance = (RpcDropAnswer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder msgId(long msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder seqNo(int seqNo) {
            this.seqNo = seqNo;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder bytes(int bytes) {
            this.bytes = bytes;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableRpcAnswerDropped build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRpcAnswerDropped(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("seqNo");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("bytes");
            }
            return "Cannot build RpcAnswerDropped, some of required attributes are not set " + attributes;
        }
    }
}

