/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.RpcError;

public final class ImmutableRpcError
implements RpcError {
    private final int identifier;
    private final int errorCode;
    private final String errorMessage;

    private ImmutableRpcError(int errorCode, String errorMessage) {
        this.errorCode = errorCode;
        this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
        this.identifier = RpcError.super.identifier();
    }

    private ImmutableRpcError(Builder builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RpcError.super.identifier();
    }

    private ImmutableRpcError(int identifier, int errorCode, String errorMessage) {
        this.identifier = identifier;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int errorCode() {
        return this.errorCode;
    }

    @Override
    public String errorMessage() {
        return this.errorMessage;
    }

    public final ImmutableRpcError withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRpcError(value, this.errorCode, this.errorMessage);
    }

    public final ImmutableRpcError withErrorCode(int value) {
        if (this.errorCode == value) {
            return this;
        }
        return new ImmutableRpcError(this.identifier, value, this.errorMessage);
    }

    public final ImmutableRpcError withErrorMessage(String value) {
        String newValue = Objects.requireNonNull(value, "errorMessage");
        if (this.errorMessage.equals(newValue)) {
            return this;
        }
        return new ImmutableRpcError(this.identifier, this.errorCode, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRpcError && this.equalTo(0, (ImmutableRpcError)another);
    }

    private boolean equalTo(int synthetic, ImmutableRpcError another) {
        return this.identifier == another.identifier && this.errorCode == another.errorCode && this.errorMessage.equals(another.errorMessage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.errorCode;
        h += (h << 5) + this.errorMessage.hashCode();
        return h;
    }

    public String toString() {
        return "RpcError{identifier=" + this.identifier + ", errorCode=" + this.errorCode + ", errorMessage=" + this.errorMessage + "}";
    }

    public static ImmutableRpcError of(int errorCode, String errorMessage) {
        return new ImmutableRpcError(errorCode, errorMessage);
    }

    public static ImmutableRpcError copyOf(RpcError instance) {
        if (instance instanceof ImmutableRpcError) {
            return (ImmutableRpcError)instance;
        }
        return ImmutableRpcError.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_ERROR_CODE = 1L;
        private static final long INIT_BIT_ERROR_MESSAGE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int errorCode;
        private String errorMessage;

        private Builder() {
        }

        public final Builder from(RpcError instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcError instance;
            long bits = 0L;
            if (object instanceof RpcError) {
                instance = (RpcError)object;
                this.errorMessage(instance.errorMessage());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.errorCode(instance.errorCode());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder errorCode(int errorCode) {
            this.errorCode = errorCode;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = Objects.requireNonNull(errorMessage, "errorMessage");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRpcError build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRpcError(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("errorCode");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("errorMessage");
            }
            return "Cannot build RpcError, some of required attributes are not set " + attributes;
        }
    }
}

