/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.RpcResult;

public final class ImmutableRpcResult
implements RpcResult {
    private final int identifier;
    private final long reqMsgId;
    private final Object result;

    private ImmutableRpcResult(long reqMsgId, Object result) {
        this.reqMsgId = reqMsgId;
        this.result = Objects.requireNonNull(result, "result");
        this.identifier = RpcResult.super.identifier();
    }

    private ImmutableRpcResult(Builder builder) {
        this.reqMsgId = builder.reqMsgId;
        this.result = builder.result;
        this.identifier = builder.identifierIsSet() ? builder.identifier : RpcResult.super.identifier();
    }

    private ImmutableRpcResult(int identifier, long reqMsgId, Object result) {
        this.identifier = identifier;
        this.reqMsgId = reqMsgId;
        this.result = result;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long reqMsgId() {
        return this.reqMsgId;
    }

    @Override
    public Object result() {
        return this.result;
    }

    public final ImmutableRpcResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableRpcResult(value, this.reqMsgId, this.result);
    }

    public final ImmutableRpcResult withReqMsgId(long value) {
        if (this.reqMsgId == value) {
            return this;
        }
        return new ImmutableRpcResult(this.identifier, value, this.result);
    }

    public final ImmutableRpcResult withResult(Object value) {
        if (this.result == value) {
            return this;
        }
        Object newValue = Objects.requireNonNull(value, "result");
        return new ImmutableRpcResult(this.identifier, this.reqMsgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRpcResult && this.equalTo(0, (ImmutableRpcResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableRpcResult another) {
        return this.identifier == another.identifier && this.reqMsgId == another.reqMsgId && this.result.equals(another.result);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.reqMsgId);
        h += (h << 5) + this.result.hashCode();
        return h;
    }

    public String toString() {
        return "RpcResult{identifier=" + this.identifier + ", reqMsgId=" + this.reqMsgId + ", result=" + this.result + "}";
    }

    public static ImmutableRpcResult of(long reqMsgId, Object result) {
        return new ImmutableRpcResult(reqMsgId, result);
    }

    public static ImmutableRpcResult copyOf(RpcResult instance) {
        if (instance instanceof ImmutableRpcResult) {
            return (ImmutableRpcResult)instance;
        }
        return ImmutableRpcResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_REQ_MSG_ID = 1L;
        private static final long INIT_BIT_RESULT = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long reqMsgId;
        private Object result;

        private Builder() {
        }

        public final Builder from(RpcResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            RpcResult instance;
            long bits = 0L;
            if (object instanceof RpcResult) {
                instance = (RpcResult)object;
                this.result(instance.result());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.reqMsgId(instance.reqMsgId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder reqMsgId(long reqMsgId) {
            this.reqMsgId = reqMsgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder result(Object result) {
            this.result = Objects.requireNonNull(result, "result");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableRpcResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRpcResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("reqMsgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("result");
            }
            return "Cannot build RpcResult, some of required attributes are not set " + attributes;
        }
    }
}

