/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.mtproto;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.MTProtoObject;
import telegram4j.tl.api.TlEncodingUtil;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.mtproto.ServerDHInnerData;

public final class ImmutableServerDHInnerData
implements ServerDHInnerData {
    private final int identifier;
    private final ByteBuf nonce;
    private final ByteBuf serverNonce;
    private final int g;
    private final ByteBuf dhPrime;
    private final ByteBuf gA;
    private final int serverTime;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableServerDHInnerData(int g, int serverTime) {
        this.g = g;
        this.serverTime = serverTime;
        this.nonce = null;
        this.serverNonce = null;
        this.dhPrime = null;
        this.gA = null;
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableServerDHInnerData(Builder builder) {
        this.nonce = builder.nonce_build();
        this.serverNonce = builder.serverNonce_build();
        this.g = builder.g;
        this.dhPrime = builder.dhPrime_build();
        this.gA = builder.gA_build();
        this.serverTime = builder.serverTime;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        this.identifier = this.initShim.identifier();
        this.initShim = null;
    }

    private ImmutableServerDHInnerData(int identifier, ByteBuf nonce, ByteBuf serverNonce, int g, ByteBuf dhPrime, ByteBuf gA, int serverTime) {
        this.identifier = identifier;
        this.nonce = nonce;
        this.serverNonce = serverNonce;
        this.g = g;
        this.dhPrime = dhPrime;
        this.gA = gA;
        this.serverTime = serverTime;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ServerDHInnerData.super.identifier();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public ByteBuf nonce() {
        return this.nonce.duplicate();
    }

    @Override
    public ByteBuf serverNonce() {
        return this.serverNonce.duplicate();
    }

    @Override
    public int g() {
        return this.g;
    }

    @Override
    public ByteBuf dhPrime() {
        return this.dhPrime.duplicate();
    }

    @Override
    public ByteBuf gA() {
        return this.gA.duplicate();
    }

    @Override
    public int serverTime() {
        return this.serverTime;
    }

    public final ImmutableServerDHInnerData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableServerDHInnerData(value, this.nonce, this.serverNonce, this.g, this.dhPrime, this.gA, this.serverTime);
    }

    public ImmutableServerDHInnerData withNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.nonce == newValue) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, newValue, this.serverNonce, this.g, this.dhPrime, this.gA, this.serverTime);
    }

    public ImmutableServerDHInnerData withServerNonce(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.serverNonce == newValue) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, this.nonce, newValue, this.g, this.dhPrime, this.gA, this.serverTime);
    }

    public final ImmutableServerDHInnerData withG(int value) {
        if (this.g == value) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, this.nonce, this.serverNonce, value, this.dhPrime, this.gA, this.serverTime);
    }

    public ImmutableServerDHInnerData withDhPrime(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.dhPrime == newValue) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, this.nonce, this.serverNonce, this.g, newValue, this.gA, this.serverTime);
    }

    public ImmutableServerDHInnerData withGA(ByteBuf value) {
        ByteBuf newValue = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
        if (this.gA == newValue) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, this.nonce, this.serverNonce, this.g, this.dhPrime, newValue, this.serverTime);
    }

    public final ImmutableServerDHInnerData withServerTime(int value) {
        if (this.serverTime == value) {
            return this;
        }
        return new ImmutableServerDHInnerData(this.identifier, this.nonce, this.serverNonce, this.g, this.dhPrime, this.gA, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableServerDHInnerData && this.equalTo(0, (ImmutableServerDHInnerData)another);
    }

    private boolean equalTo(int synthetic, ImmutableServerDHInnerData another) {
        return this.identifier == another.identifier && this.nonce().equals((Object)another.nonce()) && this.serverNonce().equals((Object)another.serverNonce()) && this.g == another.g && this.dhPrime().equals((Object)another.dhPrime()) && this.gA().equals((Object)another.gA()) && this.serverTime == another.serverTime;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.serverNonce().hashCode();
        h += (h << 5) + this.g;
        h += (h << 5) + this.dhPrime().hashCode();
        h += (h << 5) + this.gA().hashCode();
        h += (h << 5) + this.serverTime;
        return h;
    }

    public String toString() {
        return "ServerDHInnerData{identifier=" + this.identifier + ", nonce=" + ByteBufUtil.hexDump((ByteBuf)this.nonce) + ", serverNonce=" + ByteBufUtil.hexDump((ByteBuf)this.serverNonce) + ", g=" + this.g + ", dhPrime=" + ByteBufUtil.hexDump((ByteBuf)this.dhPrime) + ", gA=" + ByteBufUtil.hexDump((ByteBuf)this.gA) + ", serverTime=" + this.serverTime + "}";
    }

    public static ImmutableServerDHInnerData of(int g, int serverTime) {
        return new ImmutableServerDHInnerData(g, serverTime);
    }

    public static ImmutableServerDHInnerData copyOf(ServerDHInnerData instance) {
        if (instance instanceof ImmutableServerDHInnerData) {
            return (ImmutableServerDHInnerData)instance;
        }
        return ImmutableServerDHInnerData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_G = 1L;
        private static final long INIT_BIT_SERVER_TIME = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private ByteBuf nonce_value = null;
        private ByteBuf serverNonce_value = null;
        private ByteBuf dhPrime_value = null;
        private ByteBuf gA_value = null;
        private int identifier;
        private int g;
        private int serverTime;

        private Builder() {
        }

        public final Builder from(ServerDHInnerData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(MTProtoObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ServerDHInnerData instance;
            long bits = 0L;
            if (object instanceof ServerDHInnerData) {
                instance = (ServerDHInnerData)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.g(instance.g());
                this.dhPrime(instance.dhPrime());
                this.gA(instance.gA());
                this.serverTime(instance.serverTime());
                this.serverNonce(instance.serverNonce());
                this.nonce(instance.nonce());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof MTProtoObject) {
                instance = (MTProtoObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public Builder nonce(ByteBuf value) {
            this.nonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder serverNonce(ByteBuf value) {
            this.serverNonce_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder g(int g) {
            this.g = g;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Builder dhPrime(ByteBuf value) {
            this.dhPrime_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public Builder gA(ByteBuf value) {
            this.gA_value = TlEncodingUtil.copyAsUnpooled((ByteBuf)value);
            return this;
        }

        public final Builder serverTime(int serverTime) {
            this.serverTime = serverTime;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableServerDHInnerData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableServerDHInnerData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("g");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("serverTime");
            }
            return "Cannot build ServerDHInnerData, some of required attributes are not set " + attributes;
        }

        private ByteBuf nonce_build() {
            return Objects.requireNonNull(this.nonce_value);
        }

        private ByteBuf serverNonce_build() {
            return Objects.requireNonNull(this.serverNonce_value);
        }

        private ByteBuf dhPrime_build() {
            return Objects.requireNonNull(this.dhPrime_value);
        }

        private ByteBuf gA_build() {
            return Objects.requireNonNull(this.gA_value);
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableServerDHInnerData.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            return "Cannot build ServerDHInnerData, attribute initializers form cycle " + attributes;
        }
    }
}

