/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.BankCardOpenUrl;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.BankCardData;

public final class ImmutableBankCardData
implements BankCardData {
    private final int identifier;
    private final String title;
    private final List<BankCardOpenUrl> openUrls;

    private ImmutableBankCardData(String title) {
        this.title = Objects.requireNonNull(title, "title");
        this.openUrls = Collections.emptyList();
        this.identifier = BankCardData.super.identifier();
    }

    private ImmutableBankCardData(Builder builder) {
        this.title = builder.title;
        this.openUrls = ImmutableBankCardData.createUnmodifiableList(true, builder.openUrls);
        this.identifier = builder.identifierIsSet() ? builder.identifier : BankCardData.super.identifier();
    }

    private ImmutableBankCardData(int identifier, String title, List<BankCardOpenUrl> openUrls) {
        this.identifier = identifier;
        this.title = title;
        this.openUrls = openUrls;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public List<BankCardOpenUrl> openUrls() {
        return this.openUrls;
    }

    public final ImmutableBankCardData withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBankCardData(value, this.title, this.openUrls);
    }

    public final ImmutableBankCardData withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableBankCardData(this.identifier, newValue, this.openUrls);
    }

    public final ImmutableBankCardData withOpenUrls(BankCardOpenUrl ... elements) {
        List<BankCardOpenUrl> newValue = ImmutableBankCardData.createUnmodifiableList(false, ImmutableBankCardData.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableBankCardData(this.identifier, this.title, newValue);
    }

    public final ImmutableBankCardData withOpenUrls(Iterable<? extends BankCardOpenUrl> elements) {
        if (this.openUrls == elements) {
            return this;
        }
        List<BankCardOpenUrl> newValue = ImmutableBankCardData.createUnmodifiableList(false, ImmutableBankCardData.createSafeList(elements, true, false));
        return new ImmutableBankCardData(this.identifier, this.title, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBankCardData && this.equalTo(0, (ImmutableBankCardData)another);
    }

    private boolean equalTo(int synthetic, ImmutableBankCardData another) {
        return this.identifier == another.identifier && this.title.equals(another.title) && this.openUrls.equals(another.openUrls);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.openUrls.hashCode();
        return h;
    }

    public String toString() {
        return "BankCardData{identifier=" + this.identifier + ", title=" + this.title + ", openUrls=" + this.openUrls + "}";
    }

    public static ImmutableBankCardData of(String title) {
        return new ImmutableBankCardData(title);
    }

    public static ImmutableBankCardData copyOf(BankCardData instance) {
        if (instance instanceof ImmutableBankCardData) {
            return (ImmutableBankCardData)instance;
        }
        return ImmutableBankCardData.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String title;
        private List<BankCardOpenUrl> openUrls = new ArrayList<BankCardOpenUrl>();

        private Builder() {
        }

        public final Builder from(BankCardData instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            BankCardData instance;
            long bits = 0L;
            if (object instanceof BankCardData) {
                instance = (BankCardData)object;
                this.title(instance.title());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllOpenUrls(instance.openUrls());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOpenUrl(BankCardOpenUrl element) {
            this.openUrls.add(Objects.requireNonNull(element, "openUrls element"));
            return this;
        }

        public final Builder addOpenUrls(BankCardOpenUrl ... elements) {
            for (BankCardOpenUrl element : elements) {
                this.openUrls.add(Objects.requireNonNull(element, "openUrls element"));
            }
            return this;
        }

        public final Builder openUrls(Iterable<? extends BankCardOpenUrl> elements) {
            this.openUrls.clear();
            return this.addAllOpenUrls(elements);
        }

        public final Builder addAllOpenUrls(Iterable<? extends BankCardOpenUrl> elements) {
            for (BankCardOpenUrl bankCardOpenUrl : elements) {
                this.openUrls.add(Objects.requireNonNull(bankCardOpenUrl, "openUrls element"));
            }
            return this;
        }

        public ImmutableBankCardData build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBankCardData(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build BankCardData, some of required attributes are not set " + attributes;
        }
    }
}

