/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.Updates;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.BasePaymentResult;
import telegram4j.tl.payments.PaymentResult;

public final class ImmutableBasePaymentResult
implements BasePaymentResult {
    private final int identifier;
    private final Updates updates;

    private ImmutableBasePaymentResult(Updates updates) {
        this.updates = Objects.requireNonNull(updates, "updates");
        this.identifier = BasePaymentResult.super.identifier();
    }

    private ImmutableBasePaymentResult(Builder builder) {
        this.updates = builder.updates;
        this.identifier = builder.identifierIsSet() ? builder.identifier : BasePaymentResult.super.identifier();
    }

    private ImmutableBasePaymentResult(int identifier, Updates updates) {
        this.identifier = identifier;
        this.updates = updates;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public Updates updates() {
        return this.updates;
    }

    public final ImmutableBasePaymentResult withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableBasePaymentResult(value, this.updates);
    }

    public final ImmutableBasePaymentResult withUpdates(Updates value) {
        if (this.updates == value) {
            return this;
        }
        Updates newValue = Objects.requireNonNull(value, "updates");
        return new ImmutableBasePaymentResult(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableBasePaymentResult && this.equalTo(0, (ImmutableBasePaymentResult)another);
    }

    private boolean equalTo(int synthetic, ImmutableBasePaymentResult another) {
        return this.identifier == another.identifier && this.updates.equals(another.updates);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.updates.hashCode();
        return h;
    }

    public String toString() {
        return "BasePaymentResult{identifier=" + this.identifier + ", updates=" + this.updates + "}";
    }

    public static ImmutableBasePaymentResult of(Updates updates) {
        return new ImmutableBasePaymentResult(updates);
    }

    public static ImmutableBasePaymentResult copyOf(BasePaymentResult instance) {
        if (instance instanceof ImmutableBasePaymentResult) {
            return (ImmutableBasePaymentResult)instance;
        }
        return ImmutableBasePaymentResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_UPDATES = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private Updates updates;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BasePaymentResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaymentResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof BasePaymentResult) {
                instance = (BasePaymentResult)object;
                this.updates(instance.updates());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PaymentResult) {
                instance = (PaymentResult)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder updates(Updates updates) {
            this.updates = Objects.requireNonNull(updates, "updates");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableBasePaymentResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableBasePaymentResult(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("updates");
            }
            return "Cannot build BasePaymentResult, some of required attributes are not set " + attributes;
        }
    }
}

