/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.ExportedInvoice;

public final class ImmutableExportedInvoice
implements ExportedInvoice {
    private final int identifier;
    private final String url;

    private ImmutableExportedInvoice(String url) {
        this.url = Objects.requireNonNull(url, "url");
        this.identifier = ExportedInvoice.super.identifier();
    }

    private ImmutableExportedInvoice(Builder builder) {
        this.url = builder.url;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportedInvoice.super.identifier();
    }

    private ImmutableExportedInvoice(int identifier, String url) {
        this.identifier = identifier;
        this.url = url;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    public final ImmutableExportedInvoice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportedInvoice(value, this.url);
    }

    public final ImmutableExportedInvoice withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableExportedInvoice(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportedInvoice && this.equalTo(0, (ImmutableExportedInvoice)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportedInvoice another) {
        return this.identifier == another.identifier && this.url.equals(another.url);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        return h;
    }

    public String toString() {
        return "ExportedInvoice{identifier=" + this.identifier + ", url=" + this.url + "}";
    }

    public static ImmutableExportedInvoice of(String url) {
        return new ImmutableExportedInvoice(url);
    }

    public static ImmutableExportedInvoice copyOf(ExportedInvoice instance) {
        if (instance instanceof ImmutableExportedInvoice) {
            return (ImmutableExportedInvoice)instance;
        }
        return ImmutableExportedInvoice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String url;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ExportedInvoice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ExportedInvoice) {
                instance = (ExportedInvoice)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExportedInvoice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportedInvoice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build ExportedInvoice, some of required attributes are not set " + attributes;
        }
    }
}

