/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.DataJSON;
import telegram4j.tl.Invoice;
import telegram4j.tl.PaymentFormMethod;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.PaymentSavedCredentials;
import telegram4j.tl.User;
import telegram4j.tl.WebDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.PaymentForm;

public final class ImmutablePaymentForm
implements PaymentForm {
    private final int identifier;
    private final int flags;
    private final boolean canSaveCredentials;
    private final boolean passwordMissing;
    private final long formId;
    private final long botId;
    private final String title;
    private final String description;
    @Nullable
    private final WebDocument photo;
    private final Invoice invoice;
    private final long providerId;
    private final String url;
    @Nullable
    private final String nativeProvider;
    @Nullable
    private final DataJSON nativeParams;
    @Nullable
    private final List<PaymentFormMethod> additionalMethods;
    @Nullable
    private final PaymentRequestedInfo savedInfo;
    @Nullable
    private final List<PaymentSavedCredentials> savedCredentials;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePaymentForm(long formId, long botId, String title, String description, Invoice invoice, long providerId, String url) {
        this.formId = formId;
        this.botId = botId;
        this.title = Objects.requireNonNull(title, "title");
        this.description = Objects.requireNonNull(description, "description");
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.providerId = providerId;
        this.url = Objects.requireNonNull(url, "url");
        this.photo = null;
        this.nativeProvider = null;
        this.nativeParams = null;
        this.additionalMethods = null;
        this.savedInfo = null;
        this.savedCredentials = null;
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSaveCredentials = this.initShim.canSaveCredentials();
        this.passwordMissing = this.initShim.passwordMissing();
        this.initShim = null;
    }

    private ImmutablePaymentForm(Builder builder) {
        this.formId = builder.formId;
        this.botId = builder.botId;
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.invoice = builder.invoice;
        this.providerId = builder.providerId;
        this.url = builder.url;
        this.nativeProvider = builder.nativeProvider;
        this.nativeParams = builder.nativeParams;
        this.additionalMethods = builder.additionalMethods == null ? null : ImmutablePaymentForm.createUnmodifiableList(true, builder.additionalMethods);
        this.savedInfo = builder.savedInfo;
        this.savedCredentials = builder.savedCredentials == null ? null : ImmutablePaymentForm.createUnmodifiableList(true, builder.savedCredentials);
        this.users = ImmutablePaymentForm.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.canSaveCredentialsIsSet()) {
            this.initShim.canSaveCredentials(builder.canSaveCredentials);
        }
        if (builder.passwordMissingIsSet()) {
            this.initShim.passwordMissing(builder.passwordMissing);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.canSaveCredentials = this.initShim.canSaveCredentials();
        this.passwordMissing = this.initShim.passwordMissing();
        this.initShim = null;
    }

    private ImmutablePaymentForm(int identifier, int flags, boolean canSaveCredentials, boolean passwordMissing, long formId, long botId, String title, String description, @Nullable WebDocument photo, Invoice invoice, long providerId, String url, @Nullable String nativeProvider, @Nullable DataJSON nativeParams, @Nullable List<PaymentFormMethod> additionalMethods, @Nullable PaymentRequestedInfo savedInfo, @Nullable List<PaymentSavedCredentials> savedCredentials, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.canSaveCredentials = canSaveCredentials;
        this.passwordMissing = passwordMissing;
        this.formId = formId;
        this.botId = botId;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.invoice = invoice;
        this.providerId = providerId;
        this.url = url;
        this.nativeProvider = nativeProvider;
        this.nativeParams = nativeParams;
        this.additionalMethods = additionalMethods;
        this.savedInfo = savedInfo;
        this.savedCredentials = savedCredentials;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PaymentForm.super.identifier();
    }

    private int flagsInitialize() {
        return PaymentForm.super.flags();
    }

    private boolean canSaveCredentialsInitialize() {
        return PaymentForm.super.canSaveCredentials();
    }

    private boolean passwordMissingInitialize() {
        return PaymentForm.super.passwordMissing();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean canSaveCredentials() {
        InitShim shim = this.initShim;
        return shim != null ? shim.canSaveCredentials() : this.canSaveCredentials;
    }

    @Override
    public boolean passwordMissing() {
        InitShim shim = this.initShim;
        return shim != null ? shim.passwordMissing() : this.passwordMissing;
    }

    @Override
    public long formId() {
        return this.formId;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public WebDocument photo() {
        return this.photo;
    }

    @Override
    public Invoice invoice() {
        return this.invoice;
    }

    @Override
    public long providerId() {
        return this.providerId;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    @Nullable
    public String nativeProvider() {
        return this.nativeProvider;
    }

    @Override
    @Nullable
    public DataJSON nativeParams() {
        return this.nativeParams;
    }

    @Override
    @Nullable
    public List<PaymentFormMethod> additionalMethods() {
        return this.additionalMethods;
    }

    @Override
    @Nullable
    public PaymentRequestedInfo savedInfo() {
        return this.savedInfo;
    }

    @Override
    @Nullable
    public List<PaymentSavedCredentials> savedCredentials() {
        return this.savedCredentials;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePaymentForm withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePaymentForm(value, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, value, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withCanSaveCredentials(boolean value) {
        if (this.canSaveCredentials == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, value, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withPasswordMissing(boolean value) {
        if (this.passwordMissing == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, value, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withFormId(long value) {
        if (this.formId == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, value, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, value, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, newValue, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, newValue, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withPhoto(@Nullable WebDocument value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, value, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withInvoice(Invoice value) {
        if (this.invoice == value) {
            return this;
        }
        Invoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, newValue, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withProviderId(long value) {
        if (this.providerId == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, value, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, newValue, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withNativeProvider(@Nullable String value) {
        if (Objects.equals(this.nativeProvider, value)) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, value, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withNativeParams(@Nullable DataJSON value) {
        if (this.nativeParams == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, value, this.additionalMethods, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withAdditionalMethods(PaymentFormMethod ... elements) {
        if (elements == null) {
            return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, null, this.savedInfo, this.savedCredentials, this.users);
        }
        List<PaymentFormMethod> newValue = Arrays.asList(elements) == null ? null : ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, newValue, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withAdditionalMethods(@Nullable Iterable<? extends PaymentFormMethod> elements) {
        if (this.additionalMethods == elements) {
            return this;
        }
        List<PaymentFormMethod> newValue = elements == null ? null : ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(elements, true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, newValue, this.savedInfo, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withSavedInfo(@Nullable PaymentRequestedInfo value) {
        if (this.savedInfo == value) {
            return this;
        }
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, value, this.savedCredentials, this.users);
    }

    public final ImmutablePaymentForm withSavedCredentials(PaymentSavedCredentials ... elements) {
        if (elements == null) {
            return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, null, this.users);
        }
        List<PaymentSavedCredentials> newValue = Arrays.asList(elements) == null ? null : ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, newValue, this.users);
    }

    public final ImmutablePaymentForm withSavedCredentials(@Nullable Iterable<? extends PaymentSavedCredentials> elements) {
        if (this.savedCredentials == elements) {
            return this;
        }
        List<PaymentSavedCredentials> newValue = elements == null ? null : ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(elements, true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, newValue, this.users);
    }

    public final ImmutablePaymentForm withUsers(User ... elements) {
        List<User> newValue = ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, newValue);
    }

    public final ImmutablePaymentForm withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePaymentForm.createUnmodifiableList(false, ImmutablePaymentForm.createSafeList(elements, true, false));
        return new ImmutablePaymentForm(this.identifier, this.flags, this.canSaveCredentials, this.passwordMissing, this.formId, this.botId, this.title, this.description, this.photo, this.invoice, this.providerId, this.url, this.nativeProvider, this.nativeParams, this.additionalMethods, this.savedInfo, this.savedCredentials, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentForm && this.equalTo(0, (ImmutablePaymentForm)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentForm another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.canSaveCredentials == another.canSaveCredentials && this.passwordMissing == another.passwordMissing && this.formId == another.formId && this.botId == another.botId && this.title.equals(another.title) && this.description.equals(another.description) && Objects.equals(this.photo, another.photo) && this.invoice.equals(another.invoice) && this.providerId == another.providerId && this.url.equals(another.url) && Objects.equals(this.nativeProvider, another.nativeProvider) && Objects.equals(this.nativeParams, another.nativeParams) && Objects.equals(this.additionalMethods, another.additionalMethods) && Objects.equals(this.savedInfo, another.savedInfo) && Objects.equals(this.savedCredentials, another.savedCredentials) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.canSaveCredentials);
        h += (h << 5) + Boolean.hashCode(this.passwordMissing);
        h += (h << 5) + Long.hashCode(this.formId);
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + Long.hashCode(this.providerId);
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + Objects.hashCode(this.nativeProvider);
        h += (h << 5) + Objects.hashCode(this.nativeParams);
        h += (h << 5) + Objects.hashCode(this.additionalMethods);
        h += (h << 5) + Objects.hashCode(this.savedInfo);
        h += (h << 5) + Objects.hashCode(this.savedCredentials);
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PaymentForm{identifier=" + this.identifier + ", flags=" + this.flags + ", canSaveCredentials=" + this.canSaveCredentials + ", passwordMissing=" + this.passwordMissing + ", formId=" + this.formId + ", botId=" + this.botId + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", invoice=" + this.invoice + ", providerId=" + this.providerId + ", url=" + this.url + ", nativeProvider=" + this.nativeProvider + ", nativeParams=" + this.nativeParams + ", additionalMethods=" + this.additionalMethods + ", savedInfo=" + this.savedInfo + ", savedCredentials=" + this.savedCredentials + ", users=" + this.users + "}";
    }

    public static ImmutablePaymentForm of(long formId, long botId, String title, String description, Invoice invoice, long providerId, String url) {
        return new ImmutablePaymentForm(formId, botId, title, description, invoice, providerId, url);
    }

    public static ImmutablePaymentForm copyOf(PaymentForm instance) {
        if (instance instanceof ImmutablePaymentForm) {
            return (ImmutablePaymentForm)instance;
        }
        return ImmutablePaymentForm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_FORM_ID = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long INIT_BIT_TITLE = 4L;
        private static final long INIT_BIT_DESCRIPTION = 8L;
        private static final long INIT_BIT_INVOICE = 16L;
        private static final long INIT_BIT_PROVIDER_ID = 32L;
        private static final long INIT_BIT_URL = 64L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_CAN_SAVE_CREDENTIALS = 4L;
        private static final long OPT_BIT_PASSWORD_MISSING = 8L;
        private long initBits = 127L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean canSaveCredentials;
        private boolean passwordMissing;
        private long formId;
        private long botId;
        private String title;
        private String description;
        private WebDocument photo;
        private Invoice invoice;
        private long providerId;
        private String url;
        private String nativeProvider;
        private DataJSON nativeParams;
        private List<PaymentFormMethod> additionalMethods = null;
        private PaymentRequestedInfo savedInfo;
        private List<PaymentSavedCredentials> savedCredentials = null;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaymentForm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PaymentForm) {
                PaymentRequestedInfo savedInfoValue;
                List<PaymentFormMethod> additionalMethodsValue;
                instance = (PaymentForm)object;
                this.formId(instance.formId());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.flags(instance.flags());
                List<PaymentSavedCredentials> savedCredentialsValue = instance.savedCredentials();
                if (savedCredentialsValue != null) {
                    this.addAllSavedCredentials(savedCredentialsValue);
                }
                this.description(instance.description());
                WebDocument photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.title(instance.title());
                this.url(instance.url());
                this.addAllUsers(instance.users());
                this.canSaveCredentials(instance.canSaveCredentials());
                this.passwordMissing(instance.passwordMissing());
                this.providerId(instance.providerId());
                DataJSON nativeParamsValue = instance.nativeParams();
                if (nativeParamsValue != null) {
                    this.nativeParams(nativeParamsValue);
                }
                if ((additionalMethodsValue = instance.additionalMethods()) != null) {
                    this.addAllAdditionalMethods(additionalMethodsValue);
                }
                if ((savedInfoValue = instance.savedInfo()) != null) {
                    this.savedInfo(savedInfoValue);
                }
                this.botId(instance.botId());
                this.invoice(instance.invoice());
                String nativeProviderValue = instance.nativeProvider();
                if (nativeProviderValue != null) {
                    this.nativeProvider(nativeProviderValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder canSaveCredentials(boolean canSaveCredentials) {
            this.canSaveCredentials = canSaveCredentials;
            this.optBits |= 4L;
            return this;
        }

        public final Builder passwordMissing(boolean passwordMissing) {
            this.passwordMissing = passwordMissing;
            this.optBits |= 8L;
            return this;
        }

        public final Builder formId(long formId) {
            this.formId = formId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder photo(@Nullable WebDocument photo) {
            this.photo = photo;
            return this;
        }

        public final Builder invoice(Invoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder providerId(long providerId) {
            this.providerId = providerId;
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder nativeProvider(@Nullable String nativeProvider) {
            this.nativeProvider = nativeProvider;
            return this;
        }

        public final Builder nativeParams(@Nullable DataJSON nativeParams) {
            this.nativeParams = nativeParams;
            return this;
        }

        public final Builder addAdditionalMethod(PaymentFormMethod element) {
            if (this.additionalMethods == null) {
                this.additionalMethods = new ArrayList<PaymentFormMethod>();
            }
            this.additionalMethods.add(Objects.requireNonNull(element, "additionalMethods element"));
            return this;
        }

        public final Builder addAdditionalMethods(PaymentFormMethod ... elements) {
            if (this.additionalMethods == null) {
                this.additionalMethods = new ArrayList<PaymentFormMethod>();
            }
            for (PaymentFormMethod element : elements) {
                this.additionalMethods.add(Objects.requireNonNull(element, "additionalMethods element"));
            }
            return this;
        }

        public final Builder additionalMethods(@Nullable Iterable<? extends PaymentFormMethod> elements) {
            if (elements == null) {
                this.additionalMethods = null;
                return this;
            }
            this.additionalMethods = new ArrayList<PaymentFormMethod>();
            return this.addAllAdditionalMethods(elements);
        }

        public final Builder addAllAdditionalMethods(Iterable<? extends PaymentFormMethod> elements) {
            Objects.requireNonNull(elements, "additionalMethods element");
            if (this.additionalMethods == null) {
                this.additionalMethods = new ArrayList<PaymentFormMethod>();
            }
            for (PaymentFormMethod paymentFormMethod : elements) {
                this.additionalMethods.add(Objects.requireNonNull(paymentFormMethod, "additionalMethods element"));
            }
            return this;
        }

        public final Builder savedInfo(@Nullable PaymentRequestedInfo savedInfo) {
            this.savedInfo = savedInfo;
            return this;
        }

        public final Builder addSavedCredential(PaymentSavedCredentials element) {
            if (this.savedCredentials == null) {
                this.savedCredentials = new ArrayList<PaymentSavedCredentials>();
            }
            this.savedCredentials.add(Objects.requireNonNull(element, "savedCredentials element"));
            return this;
        }

        public final Builder addSavedCredentials(PaymentSavedCredentials ... elements) {
            if (this.savedCredentials == null) {
                this.savedCredentials = new ArrayList<PaymentSavedCredentials>();
            }
            for (PaymentSavedCredentials element : elements) {
                this.savedCredentials.add(Objects.requireNonNull(element, "savedCredentials element"));
            }
            return this;
        }

        public final Builder savedCredentials(@Nullable Iterable<? extends PaymentSavedCredentials> elements) {
            if (elements == null) {
                this.savedCredentials = null;
                return this;
            }
            this.savedCredentials = new ArrayList<PaymentSavedCredentials>();
            return this.addAllSavedCredentials(elements);
        }

        public final Builder addAllSavedCredentials(Iterable<? extends PaymentSavedCredentials> elements) {
            Objects.requireNonNull(elements, "savedCredentials element");
            if (this.savedCredentials == null) {
                this.savedCredentials = new ArrayList<PaymentSavedCredentials>();
            }
            for (PaymentSavedCredentials paymentSavedCredentials : elements) {
                this.savedCredentials.add(Objects.requireNonNull(paymentSavedCredentials, "savedCredentials element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePaymentForm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentForm(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean canSaveCredentialsIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean passwordMissingIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("formId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("invoice");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("providerId");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("url");
            }
            return "Cannot build PaymentForm, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte canSaveCredentialsBuildStage = 0;
        private boolean canSaveCredentials;
        private byte passwordMissingBuildStage = 0;
        private boolean passwordMissing;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePaymentForm.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePaymentForm.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean canSaveCredentials() {
            if (this.canSaveCredentialsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.canSaveCredentialsBuildStage == 0) {
                this.canSaveCredentialsBuildStage = (byte)-1;
                this.canSaveCredentials = ImmutablePaymentForm.this.canSaveCredentialsInitialize();
                this.canSaveCredentialsBuildStage = 1;
            }
            return this.canSaveCredentials;
        }

        void canSaveCredentials(boolean canSaveCredentials) {
            this.canSaveCredentials = canSaveCredentials;
            this.canSaveCredentialsBuildStage = 1;
        }

        boolean passwordMissing() {
            if (this.passwordMissingBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.passwordMissingBuildStage == 0) {
                this.passwordMissingBuildStage = (byte)-1;
                this.passwordMissing = ImmutablePaymentForm.this.passwordMissingInitialize();
                this.passwordMissingBuildStage = 1;
            }
            return this.passwordMissing;
        }

        void passwordMissing(boolean passwordMissing) {
            this.passwordMissing = passwordMissing;
            this.passwordMissingBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.canSaveCredentialsBuildStage == -1) {
                attributes.add("canSaveCredentials");
            }
            if (this.passwordMissingBuildStage == -1) {
                attributes.add("passwordMissing");
            }
            return "Cannot build PaymentForm, attribute initializers form cycle " + attributes;
        }
    }
}

