/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.Invoice;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.ShippingOption;
import telegram4j.tl.User;
import telegram4j.tl.WebDocument;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.PaymentReceipt;

public final class ImmutablePaymentReceipt
implements PaymentReceipt {
    private final int identifier;
    private final int flags;
    private final int date;
    private final long botId;
    private final long providerId;
    private final String title;
    private final String description;
    @Nullable
    private final WebDocument photo;
    private final Invoice invoice;
    @Nullable
    private final PaymentRequestedInfo info;
    @Nullable
    private final ShippingOption shipping;
    @Nullable
    private final Long tipAmount;
    private final String currency;
    private final long totalAmount;
    private final String credentialsTitle;
    private final List<User> users;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutablePaymentReceipt(int date, long botId, long providerId, String title, String description, Invoice invoice, String currency, long totalAmount, String credentialsTitle) {
        this.date = date;
        this.botId = botId;
        this.providerId = providerId;
        this.title = Objects.requireNonNull(title, "title");
        this.description = Objects.requireNonNull(description, "description");
        this.invoice = Objects.requireNonNull(invoice, "invoice");
        this.currency = Objects.requireNonNull(currency, "currency");
        this.totalAmount = totalAmount;
        this.credentialsTitle = Objects.requireNonNull(credentialsTitle, "credentialsTitle");
        this.photo = null;
        this.info = null;
        this.shipping = null;
        this.tipAmount = null;
        this.users = Collections.emptyList();
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePaymentReceipt(Builder builder) {
        this.date = builder.date;
        this.botId = builder.botId;
        this.providerId = builder.providerId;
        this.title = builder.title;
        this.description = builder.description;
        this.photo = builder.photo;
        this.invoice = builder.invoice;
        this.info = builder.info;
        this.shipping = builder.shipping;
        this.tipAmount = builder.tipAmount;
        this.currency = builder.currency;
        this.totalAmount = builder.totalAmount;
        this.credentialsTitle = builder.credentialsTitle;
        this.users = ImmutablePaymentReceipt.createUnmodifiableList(true, builder.users);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutablePaymentReceipt(int identifier, int flags, int date, long botId, long providerId, String title, String description, @Nullable WebDocument photo, Invoice invoice, @Nullable PaymentRequestedInfo info, @Nullable ShippingOption shipping, @Nullable Long tipAmount, String currency, long totalAmount, String credentialsTitle, List<User> users) {
        this.identifier = identifier;
        this.flags = flags;
        this.date = date;
        this.botId = botId;
        this.providerId = providerId;
        this.title = title;
        this.description = description;
        this.photo = photo;
        this.invoice = invoice;
        this.info = info;
        this.shipping = shipping;
        this.tipAmount = tipAmount;
        this.currency = currency;
        this.totalAmount = totalAmount;
        this.credentialsTitle = credentialsTitle;
        this.users = users;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return PaymentReceipt.super.identifier();
    }

    private int flagsInitialize() {
        return PaymentReceipt.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int date() {
        return this.date;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public long providerId() {
        return this.providerId;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    @Nullable
    public WebDocument photo() {
        return this.photo;
    }

    @Override
    public Invoice invoice() {
        return this.invoice;
    }

    @Override
    @Nullable
    public PaymentRequestedInfo info() {
        return this.info;
    }

    @Override
    @Nullable
    public ShippingOption shipping() {
        return this.shipping;
    }

    @Override
    @Nullable
    public Long tipAmount() {
        return this.tipAmount;
    }

    @Override
    public String currency() {
        return this.currency;
    }

    @Override
    public long totalAmount() {
        return this.totalAmount;
    }

    @Override
    public String credentialsTitle() {
        return this.credentialsTitle;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePaymentReceipt withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(value, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, value, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withDate(int value) {
        if (this.date == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, value, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, value, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withProviderId(long value) {
        if (this.providerId == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, value, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, newValue, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, newValue, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withPhoto(@Nullable WebDocument value) {
        if (this.photo == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, value, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withInvoice(Invoice value) {
        if (this.invoice == value) {
            return this;
        }
        Invoice newValue = Objects.requireNonNull(value, "invoice");
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, newValue, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withInfo(@Nullable PaymentRequestedInfo value) {
        if (this.info == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, value, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withShipping(@Nullable ShippingOption value) {
        if (this.shipping == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, value, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withTipAmount(@Nullable Long value) {
        if (Objects.equals(this.tipAmount, value)) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, value, this.currency, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withCurrency(String value) {
        String newValue = Objects.requireNonNull(value, "currency");
        if (this.currency.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, newValue, this.totalAmount, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withTotalAmount(long value) {
        if (this.totalAmount == value) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, value, this.credentialsTitle, this.users);
    }

    public final ImmutablePaymentReceipt withCredentialsTitle(String value) {
        String newValue = Objects.requireNonNull(value, "credentialsTitle");
        if (this.credentialsTitle.equals(newValue)) {
            return this;
        }
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, newValue, this.users);
    }

    public final ImmutablePaymentReceipt withUsers(User ... elements) {
        List<User> newValue = ImmutablePaymentReceipt.createUnmodifiableList(false, ImmutablePaymentReceipt.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, newValue);
    }

    public final ImmutablePaymentReceipt withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePaymentReceipt.createUnmodifiableList(false, ImmutablePaymentReceipt.createSafeList(elements, true, false));
        return new ImmutablePaymentReceipt(this.identifier, this.flags, this.date, this.botId, this.providerId, this.title, this.description, this.photo, this.invoice, this.info, this.shipping, this.tipAmount, this.currency, this.totalAmount, this.credentialsTitle, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePaymentReceipt && this.equalTo(0, (ImmutablePaymentReceipt)another);
    }

    private boolean equalTo(int synthetic, ImmutablePaymentReceipt another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.date == another.date && this.botId == another.botId && this.providerId == another.providerId && this.title.equals(another.title) && this.description.equals(another.description) && Objects.equals(this.photo, another.photo) && this.invoice.equals(another.invoice) && Objects.equals(this.info, another.info) && Objects.equals(this.shipping, another.shipping) && Objects.equals(this.tipAmount, another.tipAmount) && this.currency.equals(another.currency) && this.totalAmount == another.totalAmount && this.credentialsTitle.equals(another.credentialsTitle) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.date;
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + Long.hashCode(this.providerId);
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + Objects.hashCode(this.photo);
        h += (h << 5) + this.invoice.hashCode();
        h += (h << 5) + Objects.hashCode(this.info);
        h += (h << 5) + Objects.hashCode(this.shipping);
        h += (h << 5) + Objects.hashCode(this.tipAmount);
        h += (h << 5) + this.currency.hashCode();
        h += (h << 5) + Long.hashCode(this.totalAmount);
        h += (h << 5) + this.credentialsTitle.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PaymentReceipt{identifier=" + this.identifier + ", flags=" + this.flags + ", date=" + this.date + ", botId=" + this.botId + ", providerId=" + this.providerId + ", title=" + this.title + ", description=" + this.description + ", photo=" + this.photo + ", invoice=" + this.invoice + ", info=" + this.info + ", shipping=" + this.shipping + ", tipAmount=" + this.tipAmount + ", currency=" + this.currency + ", totalAmount=" + this.totalAmount + ", credentialsTitle=" + this.credentialsTitle + ", users=" + this.users + "}";
    }

    public static ImmutablePaymentReceipt of(int date, long botId, long providerId, String title, String description, Invoice invoice, String currency, long totalAmount, String credentialsTitle) {
        return new ImmutablePaymentReceipt(date, botId, providerId, title, description, invoice, currency, totalAmount, credentialsTitle);
    }

    public static ImmutablePaymentReceipt copyOf(PaymentReceipt instance) {
        if (instance instanceof ImmutablePaymentReceipt) {
            return (ImmutablePaymentReceipt)instance;
        }
        return ImmutablePaymentReceipt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_DATE = 1L;
        private static final long INIT_BIT_BOT_ID = 2L;
        private static final long INIT_BIT_PROVIDER_ID = 4L;
        private static final long INIT_BIT_TITLE = 8L;
        private static final long INIT_BIT_DESCRIPTION = 16L;
        private static final long INIT_BIT_INVOICE = 32L;
        private static final long INIT_BIT_CURRENCY = 64L;
        private static final long INIT_BIT_TOTAL_AMOUNT = 128L;
        private static final long INIT_BIT_CREDENTIALS_TITLE = 256L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 511L;
        private long optBits;
        private int identifier;
        private int flags;
        private int date;
        private long botId;
        private long providerId;
        private String title;
        private String description;
        private WebDocument photo;
        private Invoice invoice;
        private PaymentRequestedInfo info;
        private ShippingOption shipping;
        private Long tipAmount;
        private String currency;
        private long totalAmount;
        private String credentialsTitle;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PaymentReceipt instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof PaymentReceipt) {
                Long tipAmountValue;
                instance = (PaymentReceipt)object;
                this.date(instance.date());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((tipAmountValue = instance.tipAmount()) != null) {
                    this.tipAmount(tipAmountValue);
                }
                this.flags(instance.flags());
                this.description(instance.description());
                WebDocument photoValue = instance.photo();
                if (photoValue != null) {
                    this.photo(photoValue);
                }
                this.title(instance.title());
                this.addAllUsers(instance.users());
                this.totalAmount(instance.totalAmount());
                ShippingOption shippingValue = instance.shipping();
                if (shippingValue != null) {
                    this.shipping(shippingValue);
                }
                this.providerId(instance.providerId());
                this.currency(instance.currency());
                this.botId(instance.botId());
                this.invoice(instance.invoice());
                this.credentialsTitle(instance.credentialsTitle());
                PaymentRequestedInfo infoValue = instance.info();
                if (infoValue != null) {
                    this.info(infoValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder date(int date) {
            this.date = date;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder providerId(long providerId) {
            this.providerId = providerId;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder photo(@Nullable WebDocument photo) {
            this.photo = photo;
            return this;
        }

        public final Builder invoice(Invoice invoice) {
            this.invoice = Objects.requireNonNull(invoice, "invoice");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder info(@Nullable PaymentRequestedInfo info) {
            this.info = info;
            return this;
        }

        public final Builder shipping(@Nullable ShippingOption shipping) {
            this.shipping = shipping;
            return this;
        }

        public final Builder tipAmount(@Nullable Long tipAmount) {
            this.tipAmount = tipAmount;
            return this;
        }

        public final Builder currency(String currency) {
            this.currency = Objects.requireNonNull(currency, "currency");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder totalAmount(long totalAmount) {
            this.totalAmount = totalAmount;
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public final Builder credentialsTitle(String credentialsTitle) {
            this.credentialsTitle = Objects.requireNonNull(credentialsTitle, "credentialsTitle");
            this.initBits &= 0xFFFFFFFFFFFFFEFFL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePaymentReceipt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePaymentReceipt(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("date");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("providerId");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("title");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("invoice");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("currency");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("totalAmount");
            }
            if ((this.initBits & 0x100L) != 0L) {
                attributes.add("credentialsTitle");
            }
            return "Cannot build PaymentReceipt, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutablePaymentReceipt.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutablePaymentReceipt.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build PaymentReceipt, attribute initializers form cycle " + attributes;
        }
    }
}

