/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.PaymentRequestedInfo;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.SavedInfo;

public final class ImmutableSavedInfo
implements SavedInfo {
    private final int identifier;
    private final int flags;
    private final boolean hasSavedCredentials;
    @Nullable
    private final PaymentRequestedInfo savedInfo;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableSavedInfo INSTANCE = ImmutableSavedInfo.validate(new ImmutableSavedInfo());

    private ImmutableSavedInfo() {
        this.savedInfo = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasSavedCredentials = this.initShim.hasSavedCredentials();
        this.initShim = null;
    }

    private ImmutableSavedInfo(Builder builder) {
        this.savedInfo = builder.savedInfo;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        if (builder.hasSavedCredentialsIsSet()) {
            this.initShim.hasSavedCredentials(builder.hasSavedCredentials);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.hasSavedCredentials = this.initShim.hasSavedCredentials();
        this.initShim = null;
    }

    private ImmutableSavedInfo(int identifier, int flags, boolean hasSavedCredentials, @Nullable PaymentRequestedInfo savedInfo) {
        this.identifier = identifier;
        this.flags = flags;
        this.hasSavedCredentials = hasSavedCredentials;
        this.savedInfo = savedInfo;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return SavedInfo.super.identifier();
    }

    private int flagsInitialize() {
        return SavedInfo.super.flags();
    }

    private boolean hasSavedCredentialsInitialize() {
        return SavedInfo.super.hasSavedCredentials();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public boolean hasSavedCredentials() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasSavedCredentials() : this.hasSavedCredentials;
    }

    @Override
    @Nullable
    public PaymentRequestedInfo savedInfo() {
        return this.savedInfo;
    }

    public final ImmutableSavedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableSavedInfo.validate(new ImmutableSavedInfo(value, this.flags, this.hasSavedCredentials, this.savedInfo));
    }

    public final ImmutableSavedInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableSavedInfo.validate(new ImmutableSavedInfo(this.identifier, value, this.hasSavedCredentials, this.savedInfo));
    }

    public final ImmutableSavedInfo withHasSavedCredentials(boolean value) {
        if (this.hasSavedCredentials == value) {
            return this;
        }
        return ImmutableSavedInfo.validate(new ImmutableSavedInfo(this.identifier, this.flags, value, this.savedInfo));
    }

    public final ImmutableSavedInfo withSavedInfo(@Nullable PaymentRequestedInfo value) {
        if (this.savedInfo == value) {
            return this;
        }
        return ImmutableSavedInfo.validate(new ImmutableSavedInfo(this.identifier, this.flags, this.hasSavedCredentials, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSavedInfo && this.equalTo(0, (ImmutableSavedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableSavedInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hasSavedCredentials == another.hasSavedCredentials && Objects.equals(this.savedInfo, another.savedInfo);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Boolean.hashCode(this.hasSavedCredentials);
        h += (h << 5) + Objects.hashCode(this.savedInfo);
        return h;
    }

    public String toString() {
        return "SavedInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", hasSavedCredentials=" + this.hasSavedCredentials + ", savedInfo=" + this.savedInfo + "}";
    }

    public static ImmutableSavedInfo of() {
        return INSTANCE;
    }

    private static ImmutableSavedInfo validate(ImmutableSavedInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableSavedInfo copyOf(SavedInfo instance) {
        if (instance instanceof ImmutableSavedInfo) {
            return (ImmutableSavedInfo)instance;
        }
        return ImmutableSavedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private static final long OPT_BIT_HAS_SAVED_CREDENTIALS = 4L;
        private long optBits;
        private int identifier;
        private int flags;
        private boolean hasSavedCredentials;
        private PaymentRequestedInfo savedInfo;

        private Builder() {
        }

        public final Builder from(SavedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            SavedInfo instance;
            long bits = 0L;
            if (object instanceof SavedInfo) {
                PaymentRequestedInfo savedInfoValue;
                instance = (SavedInfo)object;
                this.hasSavedCredentials(instance.hasSavedCredentials());
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((savedInfoValue = instance.savedInfo()) != null) {
                    this.savedInfo(savedInfoValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hasSavedCredentials(boolean hasSavedCredentials) {
            this.hasSavedCredentials = hasSavedCredentials;
            this.optBits |= 4L;
            return this;
        }

        public final Builder savedInfo(@Nullable PaymentRequestedInfo savedInfo) {
            this.savedInfo = savedInfo;
            return this;
        }

        public ImmutableSavedInfo build() {
            return ImmutableSavedInfo.validate(new ImmutableSavedInfo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean hasSavedCredentialsIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;
        private byte hasSavedCredentialsBuildStage = 0;
        private boolean hasSavedCredentials;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableSavedInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableSavedInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        boolean hasSavedCredentials() {
            if (this.hasSavedCredentialsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasSavedCredentialsBuildStage == 0) {
                this.hasSavedCredentialsBuildStage = (byte)-1;
                this.hasSavedCredentials = ImmutableSavedInfo.this.hasSavedCredentialsInitialize();
                this.hasSavedCredentialsBuildStage = 1;
            }
            return this.hasSavedCredentials;
        }

        void hasSavedCredentials(boolean hasSavedCredentials) {
            this.hasSavedCredentials = hasSavedCredentials;
            this.hasSavedCredentialsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            if (this.hasSavedCredentialsBuildStage == -1) {
                attributes.add("hasSavedCredentials");
            }
            return "Cannot build SavedInfo, attribute initializers form cycle " + attributes;
        }
    }
}

