/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.payments;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.ShippingOption;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.payments.ValidatedRequestedInfo;

public final class ImmutableValidatedRequestedInfo
implements ValidatedRequestedInfo {
    private final int identifier;
    private final int flags;
    @Nullable
    private final String id;
    @Nullable
    private final List<ShippingOption> shippingOptions;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final ImmutableValidatedRequestedInfo INSTANCE = ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo());

    private ImmutableValidatedRequestedInfo() {
        this.id = null;
        this.shippingOptions = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableValidatedRequestedInfo(Builder builder) {
        this.id = builder.id;
        List<ShippingOption> list = this.shippingOptions = builder.shippingOptions == null ? null : ImmutableValidatedRequestedInfo.createUnmodifiableList(true, builder.shippingOptions);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableValidatedRequestedInfo(int identifier, int flags, @Nullable String id, @Nullable List<ShippingOption> shippingOptions) {
        this.identifier = identifier;
        this.flags = flags;
        this.id = id;
        this.shippingOptions = shippingOptions;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ValidatedRequestedInfo.super.identifier();
    }

    private int flagsInitialize() {
        return ValidatedRequestedInfo.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    @Nullable
    public String id() {
        return this.id;
    }

    @Override
    @Nullable
    public List<ShippingOption> shippingOptions() {
        return this.shippingOptions;
    }

    public final ImmutableValidatedRequestedInfo withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(value, this.flags, this.id, this.shippingOptions));
    }

    public final ImmutableValidatedRequestedInfo withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this.identifier, value, this.id, this.shippingOptions));
    }

    public final ImmutableValidatedRequestedInfo withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this.identifier, this.flags, value, this.shippingOptions));
    }

    public final ImmutableValidatedRequestedInfo withShippingOptions(ShippingOption ... elements) {
        if (elements == null) {
            return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this.identifier, this.flags, this.id, null));
        }
        List<ShippingOption> newValue = Arrays.asList(elements) == null ? null : ImmutableValidatedRequestedInfo.createUnmodifiableList(false, ImmutableValidatedRequestedInfo.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this.identifier, this.flags, this.id, newValue));
    }

    public final ImmutableValidatedRequestedInfo withShippingOptions(@Nullable Iterable<? extends ShippingOption> elements) {
        if (this.shippingOptions == elements) {
            return this;
        }
        List<ShippingOption> newValue = elements == null ? null : ImmutableValidatedRequestedInfo.createUnmodifiableList(false, ImmutableValidatedRequestedInfo.createSafeList(elements, true, false));
        return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this.identifier, this.flags, this.id, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableValidatedRequestedInfo && this.equalTo(0, (ImmutableValidatedRequestedInfo)another);
    }

    private boolean equalTo(int synthetic, ImmutableValidatedRequestedInfo another) {
        return this.identifier == another.identifier && this.flags == another.flags && Objects.equals(this.id, another.id) && Objects.equals(this.shippingOptions, another.shippingOptions);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.shippingOptions);
        return h;
    }

    public String toString() {
        return "ValidatedRequestedInfo{identifier=" + this.identifier + ", flags=" + this.flags + ", id=" + this.id + ", shippingOptions=" + this.shippingOptions + "}";
    }

    public static ImmutableValidatedRequestedInfo of() {
        return INSTANCE;
    }

    private static ImmutableValidatedRequestedInfo validate(ImmutableValidatedRequestedInfo instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    public static ImmutableValidatedRequestedInfo copyOf(ValidatedRequestedInfo instance) {
        if (instance instanceof ImmutableValidatedRequestedInfo) {
            return (ImmutableValidatedRequestedInfo)instance;
        }
        return ImmutableValidatedRequestedInfo.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long optBits;
        private int identifier;
        private int flags;
        private String id;
        private List<ShippingOption> shippingOptions = null;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ValidatedRequestedInfo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ValidatedRequestedInfo) {
                List<ShippingOption> shippingOptionsValue;
                String idValue;
                instance = (ValidatedRequestedInfo)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((idValue = instance.id()) != null) {
                    this.id(idValue);
                }
                if ((shippingOptionsValue = instance.shippingOptions()) != null) {
                    this.addAllShippingOptions(shippingOptionsValue);
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder addShippingOption(ShippingOption element) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            this.shippingOptions.add(Objects.requireNonNull(element, "shippingOptions element"));
            return this;
        }

        public final Builder addShippingOptions(ShippingOption ... elements) {
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            for (ShippingOption element : elements) {
                this.shippingOptions.add(Objects.requireNonNull(element, "shippingOptions element"));
            }
            return this;
        }

        public final Builder shippingOptions(@Nullable Iterable<? extends ShippingOption> elements) {
            if (elements == null) {
                this.shippingOptions = null;
                return this;
            }
            this.shippingOptions = new ArrayList<ShippingOption>();
            return this.addAllShippingOptions(elements);
        }

        public final Builder addAllShippingOptions(Iterable<? extends ShippingOption> elements) {
            Objects.requireNonNull(elements, "shippingOptions element");
            if (this.shippingOptions == null) {
                this.shippingOptions = new ArrayList<ShippingOption>();
            }
            for (ShippingOption shippingOption : elements) {
                this.shippingOptions.add(Objects.requireNonNull(shippingOption, "shippingOptions element"));
            }
            return this;
        }

        public ImmutableValidatedRequestedInfo build() {
            return ImmutableValidatedRequestedInfo.validate(new ImmutableValidatedRequestedInfo(this));
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableValidatedRequestedInfo.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableValidatedRequestedInfo.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build ValidatedRequestedInfo, attribute initializers form cycle " + attributes;
        }
    }
}

