/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.phone.ExportedGroupCallInvite;

public final class ImmutableExportedGroupCallInvite
implements ExportedGroupCallInvite {
    private final int identifier;
    private final String link;

    private ImmutableExportedGroupCallInvite(String link) {
        this.link = Objects.requireNonNull(link, "link");
        this.identifier = ExportedGroupCallInvite.super.identifier();
    }

    private ImmutableExportedGroupCallInvite(Builder builder) {
        this.link = builder.link;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ExportedGroupCallInvite.super.identifier();
    }

    private ImmutableExportedGroupCallInvite(int identifier, String link) {
        this.identifier = identifier;
        this.link = link;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String link() {
        return this.link;
    }

    public final ImmutableExportedGroupCallInvite withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableExportedGroupCallInvite(value, this.link);
    }

    public final ImmutableExportedGroupCallInvite withLink(String value) {
        String newValue = Objects.requireNonNull(value, "link");
        if (this.link.equals(newValue)) {
            return this;
        }
        return new ImmutableExportedGroupCallInvite(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExportedGroupCallInvite && this.equalTo(0, (ImmutableExportedGroupCallInvite)another);
    }

    private boolean equalTo(int synthetic, ImmutableExportedGroupCallInvite another) {
        return this.identifier == another.identifier && this.link.equals(another.link);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.link.hashCode();
        return h;
    }

    public String toString() {
        return "ExportedGroupCallInvite{identifier=" + this.identifier + ", link=" + this.link + "}";
    }

    public static ImmutableExportedGroupCallInvite of(String link) {
        return new ImmutableExportedGroupCallInvite(link);
    }

    public static ImmutableExportedGroupCallInvite copyOf(ExportedGroupCallInvite instance) {
        if (instance instanceof ImmutableExportedGroupCallInvite) {
            return (ImmutableExportedGroupCallInvite)instance;
        }
        return ImmutableExportedGroupCallInvite.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_LINK = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String link;

        private Builder() {
        }

        public final Builder from(ExportedGroupCallInvite instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ExportedGroupCallInvite instance;
            long bits = 0L;
            if (object instanceof ExportedGroupCallInvite) {
                instance = (ExportedGroupCallInvite)object;
                this.link(instance.link());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder link(String link) {
            this.link = Objects.requireNonNull(link, "link");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableExportedGroupCallInvite build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExportedGroupCallInvite(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("link");
            }
            return "Cannot build ExportedGroupCallInvite, some of required attributes are not set " + attributes;
        }
    }
}

