/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.GroupCall;
import telegram4j.tl.GroupCallParticipant;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutableGroupCall
implements telegram4j.tl.phone.GroupCall {
    private final int identifier;
    private final GroupCall call;
    private final List<GroupCallParticipant> participants;
    private final String participantsNextOffset;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableGroupCall(GroupCall call, String participantsNextOffset) {
        this.call = Objects.requireNonNull(call, "call");
        this.participantsNextOffset = Objects.requireNonNull(participantsNextOffset, "participantsNextOffset");
        this.participants = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = telegram4j.tl.phone.GroupCall.super.identifier();
    }

    private ImmutableGroupCall(Builder builder) {
        this.call = builder.call;
        this.participants = ImmutableGroupCall.createUnmodifiableList(true, builder.participants);
        this.participantsNextOffset = builder.participantsNextOffset;
        this.chats = ImmutableGroupCall.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableGroupCall.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : telegram4j.tl.phone.GroupCall.super.identifier();
    }

    private ImmutableGroupCall(int identifier, GroupCall call, List<GroupCallParticipant> participants, String participantsNextOffset, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.call = call;
        this.participants = participants;
        this.participantsNextOffset = participantsNextOffset;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public GroupCall call() {
        return this.call;
    }

    @Override
    public List<GroupCallParticipant> participants() {
        return this.participants;
    }

    @Override
    public String participantsNextOffset() {
        return this.participantsNextOffset;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableGroupCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCall(value, this.call, this.participants, this.participantsNextOffset, this.chats, this.users);
    }

    public final ImmutableGroupCall withCall(GroupCall value) {
        if (this.call == value) {
            return this;
        }
        GroupCall newValue = Objects.requireNonNull(value, "call");
        return new ImmutableGroupCall(this.identifier, newValue, this.participants, this.participantsNextOffset, this.chats, this.users);
    }

    public final ImmutableGroupCall withParticipants(GroupCallParticipant ... elements) {
        List<GroupCallParticipant> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupCall(this.identifier, this.call, newValue, this.participantsNextOffset, this.chats, this.users);
    }

    public final ImmutableGroupCall withParticipants(Iterable<? extends GroupCallParticipant> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<GroupCallParticipant> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(elements, true, false));
        return new ImmutableGroupCall(this.identifier, this.call, newValue, this.participantsNextOffset, this.chats, this.users);
    }

    public final ImmutableGroupCall withParticipantsNextOffset(String value) {
        String newValue = Objects.requireNonNull(value, "participantsNextOffset");
        if (this.participantsNextOffset.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupCall(this.identifier, this.call, this.participants, newValue, this.chats, this.users);
    }

    public final ImmutableGroupCall withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupCall(this.identifier, this.call, this.participants, this.participantsNextOffset, newValue, this.users);
    }

    public final ImmutableGroupCall withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(elements, true, false));
        return new ImmutableGroupCall(this.identifier, this.call, this.participants, this.participantsNextOffset, newValue, this.users);
    }

    public final ImmutableGroupCall withUsers(User ... elements) {
        List<User> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupCall(this.identifier, this.call, this.participants, this.participantsNextOffset, this.chats, newValue);
    }

    public final ImmutableGroupCall withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableGroupCall.createUnmodifiableList(false, ImmutableGroupCall.createSafeList(elements, true, false));
        return new ImmutableGroupCall(this.identifier, this.call, this.participants, this.participantsNextOffset, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCall && this.equalTo(0, (ImmutableGroupCall)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCall another) {
        return this.identifier == another.identifier && this.call.equals(another.call) && this.participants.equals(another.participants) && this.participantsNextOffset.equals(another.participantsNextOffset) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.call.hashCode();
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + this.participantsNextOffset.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "GroupCall{identifier=" + this.identifier + ", call=" + this.call + ", participants=" + this.participants + ", participantsNextOffset=" + this.participantsNextOffset + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableGroupCall of(GroupCall call, String participantsNextOffset) {
        return new ImmutableGroupCall(call, participantsNextOffset);
    }

    public static ImmutableGroupCall copyOf(telegram4j.tl.phone.GroupCall instance) {
        if (instance instanceof ImmutableGroupCall) {
            return (ImmutableGroupCall)instance;
        }
        return ImmutableGroupCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_CALL = 1L;
        private static final long INIT_BIT_PARTICIPANTS_NEXT_OFFSET = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private GroupCall call;
        private List<GroupCallParticipant> participants = new ArrayList<GroupCallParticipant>();
        private String participantsNextOffset;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.phone.GroupCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.phone.GroupCall) {
                instance = (telegram4j.tl.phone.GroupCall)object;
                this.call(instance.call());
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.participantsNextOffset(instance.participantsNextOffset());
                this.addAllUsers(instance.users());
                this.addAllParticipants(instance.participants());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder call(GroupCall call) {
            this.call = Objects.requireNonNull(call, "call");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParticipant(GroupCallParticipant element) {
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(GroupCallParticipant ... elements) {
            for (GroupCallParticipant element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(Iterable<? extends GroupCallParticipant> elements) {
            this.participants.clear();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends GroupCallParticipant> elements) {
            for (GroupCallParticipant groupCallParticipant : elements) {
                this.participants.add(Objects.requireNonNull(groupCallParticipant, "participants element"));
            }
            return this;
        }

        public final Builder participantsNextOffset(String participantsNextOffset) {
            this.participantsNextOffset = Objects.requireNonNull(participantsNextOffset, "participantsNextOffset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableGroupCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("call");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("participantsNextOffset");
            }
            return "Cannot build GroupCall, some of required attributes are not set " + attributes;
        }
    }
}

