/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.GroupCallStreamChannel;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.phone.GroupCallStreamChannels;

public final class ImmutableGroupCallStreamChannels
implements GroupCallStreamChannels {
    private final int identifier;
    private final List<GroupCallStreamChannel> channels;

    private ImmutableGroupCallStreamChannels(Builder builder) {
        this.channels = ImmutableGroupCallStreamChannels.createUnmodifiableList(true, builder.channels);
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupCallStreamChannels.super.identifier();
    }

    private ImmutableGroupCallStreamChannels(int identifier, List<GroupCallStreamChannel> channels) {
        this.identifier = identifier;
        this.channels = channels;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<GroupCallStreamChannel> channels() {
        return this.channels;
    }

    public final ImmutableGroupCallStreamChannels withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallStreamChannels(value, this.channels);
    }

    public final ImmutableGroupCallStreamChannels withChannels(GroupCallStreamChannel ... elements) {
        List<GroupCallStreamChannel> newValue = ImmutableGroupCallStreamChannels.createUnmodifiableList(false, ImmutableGroupCallStreamChannels.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupCallStreamChannels(this.identifier, newValue);
    }

    public final ImmutableGroupCallStreamChannels withChannels(Iterable<? extends GroupCallStreamChannel> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<GroupCallStreamChannel> newValue = ImmutableGroupCallStreamChannels.createUnmodifiableList(false, ImmutableGroupCallStreamChannels.createSafeList(elements, true, false));
        return new ImmutableGroupCallStreamChannels(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallStreamChannels && this.equalTo(0, (ImmutableGroupCallStreamChannels)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallStreamChannels another) {
        return this.identifier == another.identifier && this.channels.equals(another.channels);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.channels.hashCode();
        return h;
    }

    public String toString() {
        return "GroupCallStreamChannels{identifier=" + this.identifier + ", channels=" + this.channels + "}";
    }

    public static ImmutableGroupCallStreamChannels copyOf(GroupCallStreamChannels instance) {
        if (instance instanceof ImmutableGroupCallStreamChannels) {
            return (ImmutableGroupCallStreamChannels)instance;
        }
        return ImmutableGroupCallStreamChannels.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<GroupCallStreamChannel> channels = new ArrayList<GroupCallStreamChannel>();

        private Builder() {
        }

        public final Builder from(GroupCallStreamChannels instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCallStreamChannels instance;
            long bits = 0L;
            if (object instanceof GroupCallStreamChannels) {
                instance = (GroupCallStreamChannels)object;
                this.addAllChannels(instance.channels());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addChannel(GroupCallStreamChannel element) {
            this.channels.add(Objects.requireNonNull(element, "channels element"));
            return this;
        }

        public final Builder addChannels(GroupCallStreamChannel ... elements) {
            for (GroupCallStreamChannel element : elements) {
                this.channels.add(Objects.requireNonNull(element, "channels element"));
            }
            return this;
        }

        public final Builder channels(Iterable<? extends GroupCallStreamChannel> elements) {
            this.channels.clear();
            return this.addAllChannels(elements);
        }

        public final Builder addAllChannels(Iterable<? extends GroupCallStreamChannel> elements) {
            for (GroupCallStreamChannel groupCallStreamChannel : elements) {
                this.channels.add(Objects.requireNonNull(groupCallStreamChannel, "channels element"));
            }
            return this;
        }

        public ImmutableGroupCallStreamChannels build() {
            return new ImmutableGroupCallStreamChannels(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

