/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.phone.GroupCallStreamRtmpUrl;

public final class ImmutableGroupCallStreamRtmpUrl
implements GroupCallStreamRtmpUrl {
    private final int identifier;
    private final String url;
    private final String key;

    private ImmutableGroupCallStreamRtmpUrl(String url, String key) {
        this.url = Objects.requireNonNull(url, "url");
        this.key = Objects.requireNonNull(key, "key");
        this.identifier = GroupCallStreamRtmpUrl.super.identifier();
    }

    private ImmutableGroupCallStreamRtmpUrl(Builder builder) {
        this.url = builder.url;
        this.key = builder.key;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupCallStreamRtmpUrl.super.identifier();
    }

    private ImmutableGroupCallStreamRtmpUrl(int identifier, String url, String key) {
        this.identifier = identifier;
        this.url = url;
        this.key = key;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public String key() {
        return this.key;
    }

    public final ImmutableGroupCallStreamRtmpUrl withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupCallStreamRtmpUrl(value, this.url, this.key);
    }

    public final ImmutableGroupCallStreamRtmpUrl withUrl(String value) {
        String newValue = Objects.requireNonNull(value, "url");
        if (this.url.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupCallStreamRtmpUrl(this.identifier, newValue, this.key);
    }

    public final ImmutableGroupCallStreamRtmpUrl withKey(String value) {
        String newValue = Objects.requireNonNull(value, "key");
        if (this.key.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupCallStreamRtmpUrl(this.identifier, this.url, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupCallStreamRtmpUrl && this.equalTo(0, (ImmutableGroupCallStreamRtmpUrl)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupCallStreamRtmpUrl another) {
        return this.identifier == another.identifier && this.url.equals(another.url) && this.key.equals(another.key);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.url.hashCode();
        h += (h << 5) + this.key.hashCode();
        return h;
    }

    public String toString() {
        return "GroupCallStreamRtmpUrl{identifier=" + this.identifier + ", url=" + this.url + ", key=" + this.key + "}";
    }

    public static ImmutableGroupCallStreamRtmpUrl of(String url, String key) {
        return new ImmutableGroupCallStreamRtmpUrl(url, key);
    }

    public static ImmutableGroupCallStreamRtmpUrl copyOf(GroupCallStreamRtmpUrl instance) {
        if (instance instanceof ImmutableGroupCallStreamRtmpUrl) {
            return (ImmutableGroupCallStreamRtmpUrl)instance;
        }
        return ImmutableGroupCallStreamRtmpUrl.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_URL = 1L;
        private static final long INIT_BIT_KEY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String url;
        private String key;

        private Builder() {
        }

        public final Builder from(GroupCallStreamRtmpUrl instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupCallStreamRtmpUrl instance;
            long bits = 0L;
            if (object instanceof GroupCallStreamRtmpUrl) {
                instance = (GroupCallStreamRtmpUrl)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.url(instance.url());
                this.key(instance.key());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder url(String url) {
            this.url = Objects.requireNonNull(url, "url");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder key(String key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableGroupCallStreamRtmpUrl build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupCallStreamRtmpUrl(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("url");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("key");
            }
            return "Cannot build GroupCallStreamRtmpUrl, some of required attributes are not set " + attributes;
        }
    }
}

