/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.GroupCallParticipant;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.phone.GroupParticipants;

public final class ImmutableGroupParticipants
implements GroupParticipants {
    private final int identifier;
    private final int count;
    private final List<GroupCallParticipant> participants;
    private final String nextOffset;
    private final List<Chat> chats;
    private final List<User> users;
    private final int version;

    private ImmutableGroupParticipants(int count, String nextOffset, int version) {
        this.count = count;
        this.nextOffset = Objects.requireNonNull(nextOffset, "nextOffset");
        this.version = version;
        this.participants = Collections.emptyList();
        this.chats = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = GroupParticipants.super.identifier();
    }

    private ImmutableGroupParticipants(Builder builder) {
        this.count = builder.count;
        this.participants = ImmutableGroupParticipants.createUnmodifiableList(true, builder.participants);
        this.nextOffset = builder.nextOffset;
        this.chats = ImmutableGroupParticipants.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableGroupParticipants.createUnmodifiableList(true, builder.users);
        this.version = builder.version;
        this.identifier = builder.identifierIsSet() ? builder.identifier : GroupParticipants.super.identifier();
    }

    private ImmutableGroupParticipants(int identifier, int count, List<GroupCallParticipant> participants, String nextOffset, List<Chat> chats, List<User> users, int version) {
        this.identifier = identifier;
        this.count = count;
        this.participants = participants;
        this.nextOffset = nextOffset;
        this.chats = chats;
        this.users = users;
        this.version = version;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<GroupCallParticipant> participants() {
        return this.participants;
    }

    @Override
    public String nextOffset() {
        return this.nextOffset;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    @Override
    public int version() {
        return this.version;
    }

    public final ImmutableGroupParticipants withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableGroupParticipants(value, this.count, this.participants, this.nextOffset, this.chats, this.users, this.version);
    }

    public final ImmutableGroupParticipants withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutableGroupParticipants(this.identifier, value, this.participants, this.nextOffset, this.chats, this.users, this.version);
    }

    public final ImmutableGroupParticipants withParticipants(GroupCallParticipant ... elements) {
        List<GroupCallParticipant> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, newValue, this.nextOffset, this.chats, this.users, this.version);
    }

    public final ImmutableGroupParticipants withParticipants(Iterable<? extends GroupCallParticipant> elements) {
        if (this.participants == elements) {
            return this;
        }
        List<GroupCallParticipant> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(elements, true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, newValue, this.nextOffset, this.chats, this.users, this.version);
    }

    public final ImmutableGroupParticipants withNextOffset(String value) {
        String newValue = Objects.requireNonNull(value, "nextOffset");
        if (this.nextOffset.equals(newValue)) {
            return this;
        }
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, newValue, this.chats, this.users, this.version);
    }

    public final ImmutableGroupParticipants withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, this.nextOffset, newValue, this.users, this.version);
    }

    public final ImmutableGroupParticipants withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(elements, true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, this.nextOffset, newValue, this.users, this.version);
    }

    public final ImmutableGroupParticipants withUsers(User ... elements) {
        List<User> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, this.nextOffset, this.chats, newValue, this.version);
    }

    public final ImmutableGroupParticipants withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableGroupParticipants.createUnmodifiableList(false, ImmutableGroupParticipants.createSafeList(elements, true, false));
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, this.nextOffset, this.chats, newValue, this.version);
    }

    public final ImmutableGroupParticipants withVersion(int value) {
        if (this.version == value) {
            return this;
        }
        return new ImmutableGroupParticipants(this.identifier, this.count, this.participants, this.nextOffset, this.chats, this.users, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGroupParticipants && this.equalTo(0, (ImmutableGroupParticipants)another);
    }

    private boolean equalTo(int synthetic, ImmutableGroupParticipants another) {
        return this.identifier == another.identifier && this.count == another.count && this.participants.equals(another.participants) && this.nextOffset.equals(another.nextOffset) && this.chats.equals(another.chats) && this.users.equals(another.users) && this.version == another.version;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.participants.hashCode();
        h += (h << 5) + this.nextOffset.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        h += (h << 5) + this.version;
        return h;
    }

    public String toString() {
        return "GroupParticipants{identifier=" + this.identifier + ", count=" + this.count + ", participants=" + this.participants + ", nextOffset=" + this.nextOffset + ", chats=" + this.chats + ", users=" + this.users + ", version=" + this.version + "}";
    }

    public static ImmutableGroupParticipants of(int count, String nextOffset, int version) {
        return new ImmutableGroupParticipants(count, nextOffset, version);
    }

    public static ImmutableGroupParticipants copyOf(GroupParticipants instance) {
        if (instance instanceof ImmutableGroupParticipants) {
            return (ImmutableGroupParticipants)instance;
        }
        return ImmutableGroupParticipants.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long INIT_BIT_NEXT_OFFSET = 2L;
        private static final long INIT_BIT_VERSION = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private int count;
        private List<GroupCallParticipant> participants = new ArrayList<GroupCallParticipant>();
        private String nextOffset;
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();
        private int version;

        private Builder() {
        }

        public final Builder from(GroupParticipants instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            GroupParticipants instance;
            long bits = 0L;
            if (object instanceof GroupParticipants) {
                instance = (GroupParticipants)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.count(instance.count());
                this.addAllChats(instance.chats());
                this.nextOffset(instance.nextOffset());
                this.version(instance.version());
                this.addAllUsers(instance.users());
                this.addAllParticipants(instance.participants());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addParticipant(GroupCallParticipant element) {
            this.participants.add(Objects.requireNonNull(element, "participants element"));
            return this;
        }

        public final Builder addParticipants(GroupCallParticipant ... elements) {
            for (GroupCallParticipant element : elements) {
                this.participants.add(Objects.requireNonNull(element, "participants element"));
            }
            return this;
        }

        public final Builder participants(Iterable<? extends GroupCallParticipant> elements) {
            this.participants.clear();
            return this.addAllParticipants(elements);
        }

        public final Builder addAllParticipants(Iterable<? extends GroupCallParticipant> elements) {
            for (GroupCallParticipant groupCallParticipant : elements) {
                this.participants.add(Objects.requireNonNull(groupCallParticipant, "participants element"));
            }
            return this;
        }

        public final Builder nextOffset(String nextOffset) {
            this.nextOffset = Objects.requireNonNull(nextOffset, "nextOffset");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public final Builder version(int version) {
            this.version = version;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableGroupParticipants build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGroupParticipants(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("nextOffset");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("version");
            }
            return "Cannot build GroupParticipants, some of required attributes are not set " + attributes;
        }
    }
}

