/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Chat;
import telegram4j.tl.Peer;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.phone.JoinAsPeers;

public final class ImmutableJoinAsPeers
implements JoinAsPeers {
    private final int identifier;
    private final List<Peer> peers;
    private final List<Chat> chats;
    private final List<User> users;

    private ImmutableJoinAsPeers(Builder builder) {
        this.peers = ImmutableJoinAsPeers.createUnmodifiableList(true, builder.peers);
        this.chats = ImmutableJoinAsPeers.createUnmodifiableList(true, builder.chats);
        this.users = ImmutableJoinAsPeers.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : JoinAsPeers.super.identifier();
    }

    private ImmutableJoinAsPeers(int identifier, List<Peer> peers, List<Chat> chats, List<User> users) {
        this.identifier = identifier;
        this.peers = peers;
        this.chats = chats;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Peer> peers() {
        return this.peers;
    }

    @Override
    public List<Chat> chats() {
        return this.chats;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutableJoinAsPeers withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableJoinAsPeers(value, this.peers, this.chats, this.users);
    }

    public final ImmutableJoinAsPeers withPeers(Peer ... elements) {
        List<Peer> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJoinAsPeers(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableJoinAsPeers withPeers(Iterable<? extends Peer> elements) {
        if (this.peers == elements) {
            return this;
        }
        List<Peer> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(elements, true, false));
        return new ImmutableJoinAsPeers(this.identifier, newValue, this.chats, this.users);
    }

    public final ImmutableJoinAsPeers withChats(Chat ... elements) {
        List<Chat> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJoinAsPeers(this.identifier, this.peers, newValue, this.users);
    }

    public final ImmutableJoinAsPeers withChats(Iterable<? extends Chat> elements) {
        if (this.chats == elements) {
            return this;
        }
        List<Chat> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(elements, true, false));
        return new ImmutableJoinAsPeers(this.identifier, this.peers, newValue, this.users);
    }

    public final ImmutableJoinAsPeers withUsers(User ... elements) {
        List<User> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableJoinAsPeers(this.identifier, this.peers, this.chats, newValue);
    }

    public final ImmutableJoinAsPeers withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutableJoinAsPeers.createUnmodifiableList(false, ImmutableJoinAsPeers.createSafeList(elements, true, false));
        return new ImmutableJoinAsPeers(this.identifier, this.peers, this.chats, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJoinAsPeers && this.equalTo(0, (ImmutableJoinAsPeers)another);
    }

    private boolean equalTo(int synthetic, ImmutableJoinAsPeers another) {
        return this.identifier == another.identifier && this.peers.equals(another.peers) && this.chats.equals(another.chats) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.peers.hashCode();
        h += (h << 5) + this.chats.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "JoinAsPeers{identifier=" + this.identifier + ", peers=" + this.peers + ", chats=" + this.chats + ", users=" + this.users + "}";
    }

    public static ImmutableJoinAsPeers copyOf(JoinAsPeers instance) {
        if (instance instanceof ImmutableJoinAsPeers) {
            return (ImmutableJoinAsPeers)instance;
        }
        return ImmutableJoinAsPeers.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long optBits;
        private int identifier;
        private List<Peer> peers = new ArrayList<Peer>();
        private List<Chat> chats = new ArrayList<Chat>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JoinAsPeers instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof JoinAsPeers) {
                instance = (JoinAsPeers)object;
                this.addAllPeers(instance.peers());
                this.addAllChats(instance.chats());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder addPeer(Peer element) {
            this.peers.add(Objects.requireNonNull(element, "peers element"));
            return this;
        }

        public final Builder addPeers(Peer ... elements) {
            for (Peer element : elements) {
                this.peers.add(Objects.requireNonNull(element, "peers element"));
            }
            return this;
        }

        public final Builder peers(Iterable<? extends Peer> elements) {
            this.peers.clear();
            return this.addAllPeers(elements);
        }

        public final Builder addAllPeers(Iterable<? extends Peer> elements) {
            for (Peer peer : elements) {
                this.peers.add(Objects.requireNonNull(peer, "peers element"));
            }
            return this;
        }

        public final Builder addChat(Chat element) {
            this.chats.add(Objects.requireNonNull(element, "chats element"));
            return this;
        }

        public final Builder addChats(Chat ... elements) {
            for (Chat element : elements) {
                this.chats.add(Objects.requireNonNull(element, "chats element"));
            }
            return this;
        }

        public final Builder chats(Iterable<? extends Chat> elements) {
            this.chats.clear();
            return this.addAllChats(elements);
        }

        public final Builder addAllChats(Iterable<? extends Chat> elements) {
            for (Chat chat : elements) {
                this.chats.add(Objects.requireNonNull(chat, "chats element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutableJoinAsPeers build() {
            return new ImmutableJoinAsPeers(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }
}

