/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.phone;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.PhoneCall;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;

public final class ImmutablePhoneCall
implements telegram4j.tl.phone.PhoneCall {
    private final int identifier;
    private final PhoneCall phoneCall;
    private final List<User> users;

    private ImmutablePhoneCall(PhoneCall phoneCall) {
        this.phoneCall = Objects.requireNonNull(phoneCall, "phoneCall");
        this.users = Collections.emptyList();
        this.identifier = telegram4j.tl.phone.PhoneCall.super.identifier();
    }

    private ImmutablePhoneCall(Builder builder) {
        this.phoneCall = builder.phoneCall;
        this.users = ImmutablePhoneCall.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : telegram4j.tl.phone.PhoneCall.super.identifier();
    }

    private ImmutablePhoneCall(int identifier, PhoneCall phoneCall, List<User> users) {
        this.identifier = identifier;
        this.phoneCall = phoneCall;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public PhoneCall phoneCall() {
        return this.phoneCall;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePhoneCall withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoneCall(value, this.phoneCall, this.users);
    }

    public final ImmutablePhoneCall withPhoneCall(PhoneCall value) {
        if (this.phoneCall == value) {
            return this;
        }
        PhoneCall newValue = Objects.requireNonNull(value, "phoneCall");
        return new ImmutablePhoneCall(this.identifier, newValue, this.users);
    }

    public final ImmutablePhoneCall withUsers(User ... elements) {
        List<User> newValue = ImmutablePhoneCall.createUnmodifiableList(false, ImmutablePhoneCall.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePhoneCall(this.identifier, this.phoneCall, newValue);
    }

    public final ImmutablePhoneCall withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePhoneCall.createUnmodifiableList(false, ImmutablePhoneCall.createSafeList(elements, true, false));
        return new ImmutablePhoneCall(this.identifier, this.phoneCall, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoneCall && this.equalTo(0, (ImmutablePhoneCall)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoneCall another) {
        return this.identifier == another.identifier && this.phoneCall.equals(another.phoneCall) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneCall.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PhoneCall{identifier=" + this.identifier + ", phoneCall=" + this.phoneCall + ", users=" + this.users + "}";
    }

    public static ImmutablePhoneCall of(PhoneCall phoneCall) {
        return new ImmutablePhoneCall(phoneCall);
    }

    public static ImmutablePhoneCall copyOf(telegram4j.tl.phone.PhoneCall instance) {
        if (instance instanceof ImmutablePhoneCall) {
            return (ImmutablePhoneCall)instance;
        }
        return ImmutablePhoneCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_CALL = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private PhoneCall phoneCall;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(telegram4j.tl.phone.PhoneCall instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof telegram4j.tl.phone.PhoneCall) {
                instance = (telegram4j.tl.phone.PhoneCall)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCall(instance.phoneCall());
                this.addAllUsers(instance.users());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneCall(PhoneCall phoneCall) {
            this.phoneCall = Objects.requireNonNull(phoneCall, "phoneCall");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePhoneCall build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoneCall(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneCall");
            }
            return "Cannot build PhoneCall, some of required attributes are not set " + attributes;
        }
    }
}

