/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.photos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.photos.Photo;

public final class ImmutablePhoto
implements Photo {
    private final int identifier;
    private final telegram4j.tl.Photo photo;
    private final List<User> users;

    private ImmutablePhoto(telegram4j.tl.Photo photo) {
        this.photo = Objects.requireNonNull(photo, "photo");
        this.users = Collections.emptyList();
        this.identifier = Photo.super.identifier();
    }

    private ImmutablePhoto(Builder builder) {
        this.photo = builder.photo;
        this.users = ImmutablePhoto.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : Photo.super.identifier();
    }

    private ImmutablePhoto(int identifier, telegram4j.tl.Photo photo, List<User> users) {
        this.identifier = identifier;
        this.photo = photo;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public telegram4j.tl.Photo photo() {
        return this.photo;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePhoto withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhoto(value, this.photo, this.users);
    }

    public final ImmutablePhoto withPhoto(telegram4j.tl.Photo value) {
        if (this.photo == value) {
            return this;
        }
        telegram4j.tl.Photo newValue = Objects.requireNonNull(value, "photo");
        return new ImmutablePhoto(this.identifier, newValue, this.users);
    }

    public final ImmutablePhoto withUsers(User ... elements) {
        List<User> newValue = ImmutablePhoto.createUnmodifiableList(false, ImmutablePhoto.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePhoto(this.identifier, this.photo, newValue);
    }

    public final ImmutablePhoto withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePhoto.createUnmodifiableList(false, ImmutablePhoto.createSafeList(elements, true, false));
        return new ImmutablePhoto(this.identifier, this.photo, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhoto && this.equalTo(0, (ImmutablePhoto)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhoto another) {
        return this.identifier == another.identifier && this.photo.equals(another.photo) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.photo.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "Photo{identifier=" + this.identifier + ", photo=" + this.photo + ", users=" + this.users + "}";
    }

    public static ImmutablePhoto of(telegram4j.tl.Photo photo) {
        return new ImmutablePhoto(photo);
    }

    public static ImmutablePhoto copyOf(Photo instance) {
        if (instance instanceof ImmutablePhoto) {
            return (ImmutablePhoto)instance;
        }
        return ImmutablePhoto.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_PHOTO = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private telegram4j.tl.Photo photo;
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(Photo instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Photo instance;
            long bits = 0L;
            if (object instanceof Photo) {
                instance = (Photo)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.photo(instance.photo());
                this.addAllUsers(instance.users());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder photo(telegram4j.tl.Photo photo) {
            this.photo = Objects.requireNonNull(photo, "photo");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePhoto build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhoto(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("photo");
            }
            return "Cannot build Photo, some of required attributes are not set " + attributes;
        }
    }
}

