/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.photos;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.Photo;
import telegram4j.tl.User;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.photos.Photos;
import telegram4j.tl.photos.PhotosSlice;

public final class ImmutablePhotosSlice
implements PhotosSlice {
    private final int identifier;
    private final int count;
    private final List<Photo> photos;
    private final List<User> users;

    private ImmutablePhotosSlice(int count) {
        this.count = count;
        this.photos = Collections.emptyList();
        this.users = Collections.emptyList();
        this.identifier = PhotosSlice.super.identifier();
    }

    private ImmutablePhotosSlice(Builder builder) {
        this.count = builder.count;
        this.photos = ImmutablePhotosSlice.createUnmodifiableList(true, builder.photos);
        this.users = ImmutablePhotosSlice.createUnmodifiableList(true, builder.users);
        this.identifier = builder.identifierIsSet() ? builder.identifier : PhotosSlice.super.identifier();
    }

    private ImmutablePhotosSlice(int identifier, int count, List<Photo> photos, List<User> users) {
        this.identifier = identifier;
        this.count = count;
        this.photos = photos;
        this.users = users;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int count() {
        return this.count;
    }

    @Override
    public List<Photo> photos() {
        return this.photos;
    }

    @Override
    public List<User> users() {
        return this.users;
    }

    public final ImmutablePhotosSlice withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutablePhotosSlice(value, this.count, this.photos, this.users);
    }

    public final ImmutablePhotosSlice withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new ImmutablePhotosSlice(this.identifier, value, this.photos, this.users);
    }

    public final ImmutablePhotosSlice withPhotos(Photo ... elements) {
        List<Photo> newValue = ImmutablePhotosSlice.createUnmodifiableList(false, ImmutablePhotosSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePhotosSlice(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutablePhotosSlice withPhotos(Iterable<? extends Photo> elements) {
        if (this.photos == elements) {
            return this;
        }
        List<Photo> newValue = ImmutablePhotosSlice.createUnmodifiableList(false, ImmutablePhotosSlice.createSafeList(elements, true, false));
        return new ImmutablePhotosSlice(this.identifier, this.count, newValue, this.users);
    }

    public final ImmutablePhotosSlice withUsers(User ... elements) {
        List<User> newValue = ImmutablePhotosSlice.createUnmodifiableList(false, ImmutablePhotosSlice.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutablePhotosSlice(this.identifier, this.count, this.photos, newValue);
    }

    public final ImmutablePhotosSlice withUsers(Iterable<? extends User> elements) {
        if (this.users == elements) {
            return this;
        }
        List<User> newValue = ImmutablePhotosSlice.createUnmodifiableList(false, ImmutablePhotosSlice.createSafeList(elements, true, false));
        return new ImmutablePhotosSlice(this.identifier, this.count, this.photos, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePhotosSlice && this.equalTo(0, (ImmutablePhotosSlice)another);
    }

    private boolean equalTo(int synthetic, ImmutablePhotosSlice another) {
        return this.identifier == another.identifier && this.count == another.count && this.photos.equals(another.photos) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.count;
        h += (h << 5) + this.photos.hashCode();
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "PhotosSlice{identifier=" + this.identifier + ", count=" + this.count + ", photos=" + this.photos + ", users=" + this.users + "}";
    }

    public static ImmutablePhotosSlice of(int count) {
        return new ImmutablePhotosSlice(count);
    }

    public static ImmutablePhotosSlice copyOf(PhotosSlice instance) {
        if (instance instanceof ImmutablePhotosSlice) {
            return (ImmutablePhotosSlice)instance;
        }
        return ImmutablePhotosSlice.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_COUNT = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int count;
        private List<Photo> photos = new ArrayList<Photo>();
        private List<User> users = new ArrayList<User>();

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(Photos instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(PhotosSlice instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            TlObject instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof Photos) {
                instance = (Photos)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllPhotos(instance.photos());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 4L;
                }
            }
            if (object instanceof PhotosSlice) {
                instance = (PhotosSlice)object;
                this.count(instance.count());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllPhotos(instance.photos());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.addAllUsers(instance.users());
                    bits |= 4L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder count(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addPhoto(Photo element) {
            this.photos.add(Objects.requireNonNull(element, "photos element"));
            return this;
        }

        public final Builder addPhotos(Photo ... elements) {
            for (Photo element : elements) {
                this.photos.add(Objects.requireNonNull(element, "photos element"));
            }
            return this;
        }

        public final Builder photos(Iterable<? extends Photo> elements) {
            this.photos.clear();
            return this.addAllPhotos(elements);
        }

        public final Builder addAllPhotos(Iterable<? extends Photo> elements) {
            for (Photo photo : elements) {
                this.photos.add(Objects.requireNonNull(photo, "photos element"));
            }
            return this;
        }

        public final Builder addUser(User element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(User ... elements) {
            for (User element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder users(Iterable<? extends User> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends User> elements) {
            for (User user : elements) {
                this.users.add(Objects.requireNonNull(user, "users element"));
            }
            return this;
        }

        public ImmutablePhotosSlice build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePhotosSlice(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("count");
            }
            return "Cannot build PhotosSlice, some of required attributes are not set " + attributes;
        }
    }
}

