/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputClientProxy;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InitConnection;

public final class ImmutableInitConnection<R, T extends TlMethod<? extends R>>
implements InitConnection<R, T> {
    private final int identifier;
    private final int flags;
    private final int apiId;
    private final String deviceModel;
    private final String systemVersion;
    private final String appVersion;
    private final String systemLangCode;
    private final String langPack;
    private final String langCode;
    @Nullable
    private final InputClientProxy proxy;
    @Nullable
    private final JsonNode params;
    private final T query;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableInitConnection(int apiId, String deviceModel, String systemVersion, String appVersion, String systemLangCode, String langPack, String langCode, T query) {
        this.apiId = apiId;
        this.deviceModel = Objects.requireNonNull(deviceModel, "deviceModel");
        this.systemVersion = Objects.requireNonNull(systemVersion, "systemVersion");
        this.appVersion = Objects.requireNonNull(appVersion, "appVersion");
        this.systemLangCode = Objects.requireNonNull(systemLangCode, "systemLangCode");
        this.langPack = Objects.requireNonNull(langPack, "langPack");
        this.langCode = Objects.requireNonNull(langCode, "langCode");
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.proxy = null;
        this.params = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInitConnection(Builder<R, T> builder) {
        this.apiId = builder.apiId;
        this.deviceModel = builder.deviceModel;
        this.systemVersion = builder.systemVersion;
        this.appVersion = builder.appVersion;
        this.systemLangCode = builder.systemLangCode;
        this.langPack = builder.langPack;
        this.langCode = builder.langCode;
        this.proxy = builder.proxy;
        this.params = builder.params;
        this.query = builder.query;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableInitConnection(int identifier, int flags, int apiId, String deviceModel, String systemVersion, String appVersion, String systemLangCode, String langPack, String langCode, @Nullable InputClientProxy proxy, @Nullable JsonNode params, T query) {
        this.identifier = identifier;
        this.flags = flags;
        this.apiId = apiId;
        this.deviceModel = deviceModel;
        this.systemVersion = systemVersion;
        this.appVersion = appVersion;
        this.systemLangCode = systemLangCode;
        this.langPack = langPack;
        this.langCode = langCode;
        this.proxy = proxy;
        this.params = params;
        this.query = query;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return InitConnection.super.identifier();
    }

    private int flagsInitialize() {
        return InitConnection.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public int apiId() {
        return this.apiId;
    }

    @Override
    public String deviceModel() {
        return this.deviceModel;
    }

    @Override
    public String systemVersion() {
        return this.systemVersion;
    }

    @Override
    public String appVersion() {
        return this.appVersion;
    }

    @Override
    public String systemLangCode() {
        return this.systemLangCode;
    }

    @Override
    public String langPack() {
        return this.langPack;
    }

    @Override
    public String langCode() {
        return this.langCode;
    }

    @Override
    @Nullable
    public InputClientProxy proxy() {
        return this.proxy;
    }

    @Override
    @Nullable
    public JsonNode params() {
        return this.params;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInitConnection<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(value, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, value, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withApiId(int value) {
        if (this.apiId == value) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, value, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withDeviceModel(String value) {
        String newValue = Objects.requireNonNull(value, "deviceModel");
        if (this.deviceModel.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, newValue, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withSystemVersion(String value) {
        String newValue = Objects.requireNonNull(value, "systemVersion");
        if (this.systemVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, newValue, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withAppVersion(String value) {
        String newValue = Objects.requireNonNull(value, "appVersion");
        if (this.appVersion.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, newValue, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withSystemLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "systemLangCode");
        if (this.systemLangCode.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, newValue, this.langPack, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withLangPack(String value) {
        String newValue = Objects.requireNonNull(value, "langPack");
        if (this.langPack.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, newValue, this.langCode, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withLangCode(String value) {
        String newValue = Objects.requireNonNull(value, "langCode");
        if (this.langCode.equals(newValue)) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, newValue, this.proxy, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withProxy(@Nullable InputClientProxy value) {
        if (this.proxy == value) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, value, this.params, this.query);
    }

    public final ImmutableInitConnection<R, T> withParams(@Nullable JsonNode value) {
        if (this.params == value) {
            return this;
        }
        return new ImmutableInitConnection<R, T>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, value, this.query);
    }

    public final ImmutableInitConnection<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInitConnection<R, TlMethod>(this.identifier, this.flags, this.apiId, this.deviceModel, this.systemVersion, this.appVersion, this.systemLangCode, this.langPack, this.langCode, this.proxy, this.params, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInitConnection && this.equalTo(0, (ImmutableInitConnection)another);
    }

    private boolean equalTo(int synthetic, ImmutableInitConnection<?, ?> another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.apiId == another.apiId && this.deviceModel.equals(another.deviceModel) && this.systemVersion.equals(another.systemVersion) && this.appVersion.equals(another.appVersion) && this.systemLangCode.equals(another.systemLangCode) && this.langPack.equals(another.langPack) && this.langCode.equals(another.langCode) && Objects.equals(this.proxy, another.proxy) && Objects.equals(this.params, another.params) && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.apiId;
        h += (h << 5) + this.deviceModel.hashCode();
        h += (h << 5) + this.systemVersion.hashCode();
        h += (h << 5) + this.appVersion.hashCode();
        h += (h << 5) + this.systemLangCode.hashCode();
        h += (h << 5) + this.langPack.hashCode();
        h += (h << 5) + this.langCode.hashCode();
        h += (h << 5) + Objects.hashCode(this.proxy);
        h += (h << 5) + Objects.hashCode(this.params);
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InitConnection{identifier=" + this.identifier + ", flags=" + this.flags + ", apiId=" + this.apiId + ", deviceModel=" + this.deviceModel + ", systemVersion=" + this.systemVersion + ", appVersion=" + this.appVersion + ", systemLangCode=" + this.systemLangCode + ", langPack=" + this.langPack + ", langCode=" + this.langCode + ", proxy=" + this.proxy + ", params=" + this.params + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInitConnection<R, T> of(int apiId, String deviceModel, String systemVersion, String appVersion, String systemLangCode, String langPack, String langCode, T query) {
        return new ImmutableInitConnection<R, T>(apiId, deviceModel, systemVersion, appVersion, systemLangCode, langPack, langCode, query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInitConnection<R, T> copyOf(InitConnection<R, T> instance) {
        if (instance instanceof ImmutableInitConnection) {
            return (ImmutableInitConnection)instance;
        }
        return ImmutableInitConnection.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_API_ID = 1L;
        private static final long INIT_BIT_DEVICE_MODEL = 2L;
        private static final long INIT_BIT_SYSTEM_VERSION = 4L;
        private static final long INIT_BIT_APP_VERSION = 8L;
        private static final long INIT_BIT_SYSTEM_LANG_CODE = 16L;
        private static final long INIT_BIT_LANG_PACK = 32L;
        private static final long INIT_BIT_LANG_CODE = 64L;
        private static final long INIT_BIT_QUERY = 128L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 255L;
        private long optBits;
        private int identifier;
        private int flags;
        private int apiId;
        private String deviceModel;
        private String systemVersion;
        private String appVersion;
        private String systemLangCode;
        private String langPack;
        private String langCode;
        private InputClientProxy proxy;
        private JsonNode params;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(InitConnection<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InitConnection instance;
            long bits = 0L;
            if (object instanceof InitConnection) {
                InputClientProxy proxyValue;
                instance = (InitConnection)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((proxyValue = instance.proxy()) != null) {
                    this.proxy(proxyValue);
                }
                this.appVersion(instance.appVersion());
                this.langPack(instance.langPack());
                this.langCode(instance.langCode());
                this.query(instance.query());
                this.flags(instance.flags());
                this.deviceModel(instance.deviceModel());
                this.systemLangCode(instance.systemLangCode());
                JsonNode paramsValue = instance.params();
                if (paramsValue != null) {
                    this.params(paramsValue);
                }
                this.systemVersion(instance.systemVersion());
                this.apiId(instance.apiId());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder<R, T> apiId(int apiId) {
            this.apiId = apiId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<R, T> deviceModel(String deviceModel) {
            this.deviceModel = Objects.requireNonNull(deviceModel, "deviceModel");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<R, T> systemVersion(String systemVersion) {
            this.systemVersion = Objects.requireNonNull(systemVersion, "systemVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder<R, T> appVersion(String appVersion) {
            this.appVersion = Objects.requireNonNull(appVersion, "appVersion");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder<R, T> systemLangCode(String systemLangCode) {
            this.systemLangCode = Objects.requireNonNull(systemLangCode, "systemLangCode");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public final Builder<R, T> langPack(String langPack) {
            this.langPack = Objects.requireNonNull(langPack, "langPack");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        public final Builder<R, T> langCode(String langCode) {
            this.langCode = Objects.requireNonNull(langCode, "langCode");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        public final Builder<R, T> proxy(@Nullable InputClientProxy proxy) {
            this.proxy = proxy;
            return this;
        }

        public final Builder<R, T> params(@Nullable JsonNode params) {
            this.params = params;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        public ImmutableInitConnection<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInitConnection(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("apiId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("deviceModel");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("systemVersion");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("appVersion");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("systemLangCode");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("langPack");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("langCode");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InitConnection, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableInitConnection.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableInitConnection.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build InitConnection, attribute initializers form cycle " + attributes;
        }
    }
}

