/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeAfterMsg;

public final class ImmutableInvokeAfterMsg<R, T extends TlMethod<? extends R>>
implements InvokeAfterMsg<R, T> {
    private final int identifier;
    private final long msgId;
    private final T query;

    private ImmutableInvokeAfterMsg(long msgId, T query) {
        this.msgId = msgId;
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.identifier = InvokeAfterMsg.super.identifier();
    }

    private ImmutableInvokeAfterMsg(Builder<R, T> builder) {
        this.msgId = builder.msgId;
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeAfterMsg.super.identifier();
    }

    private ImmutableInvokeAfterMsg(int identifier, long msgId, T query) {
        this.identifier = identifier;
        this.msgId = msgId;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long msgId() {
        return this.msgId;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeAfterMsg<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeAfterMsg<R, T>(value, this.msgId, this.query);
    }

    public final ImmutableInvokeAfterMsg<R, T> withMsgId(long value) {
        if (this.msgId == value) {
            return this;
        }
        return new ImmutableInvokeAfterMsg<R, T>(this.identifier, value, this.query);
    }

    public final ImmutableInvokeAfterMsg<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeAfterMsg<R, TlMethod>(this.identifier, this.msgId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeAfterMsg && this.equalTo(0, (ImmutableInvokeAfterMsg)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeAfterMsg<?, ?> another) {
        return this.identifier == another.identifier && this.msgId == another.msgId && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.msgId);
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeAfterMsg{identifier=" + this.identifier + ", msgId=" + this.msgId + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeAfterMsg<R, T> of(long msgId, T query) {
        return new ImmutableInvokeAfterMsg<R, T>(msgId, query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeAfterMsg<R, T> copyOf(InvokeAfterMsg<R, T> instance) {
        if (instance instanceof ImmutableInvokeAfterMsg) {
            return (ImmutableInvokeAfterMsg)instance;
        }
        return ImmutableInvokeAfterMsg.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_MSG_ID = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long msgId;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(InvokeAfterMsg<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InvokeAfterMsg instance;
            long bits = 0L;
            if (object instanceof InvokeAfterMsg) {
                instance = (InvokeAfterMsg)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.msgId(instance.msgId());
                this.query(instance.query());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> msgId(long msgId) {
            this.msgId = msgId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInvokeAfterMsg<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeAfterMsg(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("msgId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeAfterMsg, some of required attributes are not set " + attributes;
        }
    }
}

