/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeAfterMsgs;

public final class ImmutableInvokeAfterMsgs<R, T extends TlMethod<? extends R>>
implements InvokeAfterMsgs<R, T> {
    private final int identifier;
    private final List<Long> msgIds;
    private final T query;

    private ImmutableInvokeAfterMsgs(T query) {
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.msgIds = Collections.emptyList();
        this.identifier = InvokeAfterMsgs.super.identifier();
    }

    private ImmutableInvokeAfterMsgs(Builder<R, T> builder) {
        this.msgIds = ImmutableInvokeAfterMsgs.createUnmodifiableList(true, builder.msgIds);
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeAfterMsgs.super.identifier();
    }

    private ImmutableInvokeAfterMsgs(int identifier, List<Long> msgIds, T query) {
        this.identifier = identifier;
        this.msgIds = msgIds;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public List<Long> msgIds() {
        return this.msgIds;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeAfterMsgs<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeAfterMsgs<R, T>(value, this.msgIds, this.query);
    }

    public final ImmutableInvokeAfterMsgs<R, T> withMsgIds(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableInvokeAfterMsgs.createUnmodifiableList(false, wrappedList);
        return new ImmutableInvokeAfterMsgs<R, T>(this.identifier, newValue, this.query);
    }

    public final ImmutableInvokeAfterMsgs<R, T> withMsgIds(Iterable<Long> elements) {
        if (this.msgIds == elements) {
            return this;
        }
        List<Long> newValue = ImmutableInvokeAfterMsgs.createUnmodifiableList(false, ImmutableInvokeAfterMsgs.createSafeList(elements, true, false));
        return new ImmutableInvokeAfterMsgs<R, T>(this.identifier, newValue, this.query);
    }

    public final ImmutableInvokeAfterMsgs<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeAfterMsgs<R, TlMethod>(this.identifier, this.msgIds, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeAfterMsgs && this.equalTo(0, (ImmutableInvokeAfterMsgs)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeAfterMsgs<?, ?> another) {
        return this.identifier == another.identifier && this.msgIds.equals(another.msgIds) && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.msgIds.hashCode();
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeAfterMsgs{identifier=" + this.identifier + ", msgIds=" + this.msgIds + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeAfterMsgs<R, T> of(T query) {
        return new ImmutableInvokeAfterMsgs<R, T>(query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeAfterMsgs<R, T> copyOf(InvokeAfterMsgs<R, T> instance) {
        if (instance instanceof ImmutableInvokeAfterMsgs) {
            return (ImmutableInvokeAfterMsgs)instance;
        }
        return ImmutableInvokeAfterMsgs.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private List<Long> msgIds = new ArrayList<Long>();
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(InvokeAfterMsgs<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InvokeAfterMsgs instance;
            long bits = 0L;
            if (object instanceof InvokeAfterMsgs) {
                instance = (InvokeAfterMsgs)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.addAllMsgIds(instance.msgIds());
                this.query(instance.query());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> addMsgId(long element) {
            this.msgIds.add(element);
            return this;
        }

        public final Builder<R, T> addMsgIds(long ... elements) {
            for (long element : elements) {
                this.msgIds.add(element);
            }
            return this;
        }

        public final Builder<R, T> msgIds(Iterable<Long> elements) {
            this.msgIds.clear();
            return this.addAllMsgIds(elements);
        }

        public final Builder<R, T> addAllMsgIds(Iterable<Long> elements) {
            for (Long element : elements) {
                this.msgIds.add(Objects.requireNonNull(element, "msgIds element"));
            }
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInvokeAfterMsgs<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeAfterMsgs(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeAfterMsgs, some of required attributes are not set " + attributes;
        }
    }
}

