/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeWithLayer;

public final class ImmutableInvokeWithLayer<R, T extends TlMethod<? extends R>>
implements InvokeWithLayer<R, T> {
    private final int identifier;
    private final int layer;
    private final T query;

    private ImmutableInvokeWithLayer(int layer, T query) {
        this.layer = layer;
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.identifier = InvokeWithLayer.super.identifier();
    }

    private ImmutableInvokeWithLayer(Builder<R, T> builder) {
        this.layer = builder.layer;
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeWithLayer.super.identifier();
    }

    private ImmutableInvokeWithLayer(int identifier, int layer, T query) {
        this.identifier = identifier;
        this.layer = layer;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public int layer() {
        return this.layer;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeWithLayer<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeWithLayer<R, T>(value, this.layer, this.query);
    }

    public final ImmutableInvokeWithLayer<R, T> withLayer(int value) {
        if (this.layer == value) {
            return this;
        }
        return new ImmutableInvokeWithLayer<R, T>(this.identifier, value, this.query);
    }

    public final ImmutableInvokeWithLayer<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeWithLayer<R, TlMethod>(this.identifier, this.layer, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeWithLayer && this.equalTo(0, (ImmutableInvokeWithLayer)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeWithLayer<?, ?> another) {
        return this.identifier == another.identifier && this.layer == another.layer && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.layer;
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeWithLayer{identifier=" + this.identifier + ", layer=" + this.layer + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithLayer<R, T> of(int layer, T query) {
        return new ImmutableInvokeWithLayer<R, T>(layer, query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithLayer<R, T> copyOf(InvokeWithLayer<R, T> instance) {
        if (instance instanceof ImmutableInvokeWithLayer) {
            return (ImmutableInvokeWithLayer)instance;
        }
        return ImmutableInvokeWithLayer.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_LAYER = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int layer;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(InvokeWithLayer<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InvokeWithLayer) {
                instance = (InvokeWithLayer)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.layer(instance.layer());
                this.query(instance.query());
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> layer(int layer) {
            this.layer = layer;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInvokeWithLayer<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeWithLayer(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("layer");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeWithLayer, some of required attributes are not set " + attributes;
        }
    }
}

