/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.MessageRange;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeWithMessagesRange;

public final class ImmutableInvokeWithMessagesRange<R, T extends TlMethod<? extends R>>
implements InvokeWithMessagesRange<R, T> {
    private final int identifier;
    private final MessageRange range;
    private final T query;

    private ImmutableInvokeWithMessagesRange(MessageRange range, T query) {
        this.range = Objects.requireNonNull(range, "range");
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.identifier = InvokeWithMessagesRange.super.identifier();
    }

    private ImmutableInvokeWithMessagesRange(Builder<R, T> builder) {
        this.range = builder.range;
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeWithMessagesRange.super.identifier();
    }

    private ImmutableInvokeWithMessagesRange(int identifier, MessageRange range, T query) {
        this.identifier = identifier;
        this.range = range;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public MessageRange range() {
        return this.range;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeWithMessagesRange<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeWithMessagesRange<R, T>(value, this.range, this.query);
    }

    public final ImmutableInvokeWithMessagesRange<R, T> withRange(MessageRange value) {
        if (this.range == value) {
            return this;
        }
        MessageRange newValue = Objects.requireNonNull(value, "range");
        return new ImmutableInvokeWithMessagesRange<R, T>(this.identifier, newValue, this.query);
    }

    public final ImmutableInvokeWithMessagesRange<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeWithMessagesRange<R, TlMethod>(this.identifier, this.range, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeWithMessagesRange && this.equalTo(0, (ImmutableInvokeWithMessagesRange)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeWithMessagesRange<?, ?> another) {
        return this.identifier == another.identifier && this.range.equals(another.range) && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.range.hashCode();
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeWithMessagesRange{identifier=" + this.identifier + ", range=" + this.range + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithMessagesRange<R, T> of(MessageRange range, T query) {
        return new ImmutableInvokeWithMessagesRange<R, T>(range, query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithMessagesRange<R, T> copyOf(InvokeWithMessagesRange<R, T> instance) {
        if (instance instanceof ImmutableInvokeWithMessagesRange) {
            return (ImmutableInvokeWithMessagesRange)instance;
        }
        return ImmutableInvokeWithMessagesRange.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_RANGE = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private MessageRange range;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(InvokeWithMessagesRange<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            InvokeWithMessagesRange instance;
            long bits = 0L;
            if (object instanceof InvokeWithMessagesRange) {
                instance = (InvokeWithMessagesRange)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.range(instance.range());
                this.query(instance.query());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> range(MessageRange range) {
            this.range = Objects.requireNonNull(range, "range");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInvokeWithMessagesRange<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeWithMessagesRange(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("range");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeWithMessagesRange, some of required attributes are not set " + attributes;
        }
    }
}

