/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeWithTakeout;

public final class ImmutableInvokeWithTakeout<R, T extends TlMethod<? extends R>>
implements InvokeWithTakeout<R, T> {
    private final int identifier;
    private final long takeoutId;
    private final T query;

    private ImmutableInvokeWithTakeout(long takeoutId, T query) {
        this.takeoutId = takeoutId;
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.identifier = InvokeWithTakeout.super.identifier();
    }

    private ImmutableInvokeWithTakeout(Builder<R, T> builder) {
        this.takeoutId = builder.takeoutId;
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeWithTakeout.super.identifier();
    }

    private ImmutableInvokeWithTakeout(int identifier, long takeoutId, T query) {
        this.identifier = identifier;
        this.takeoutId = takeoutId;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long takeoutId() {
        return this.takeoutId;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeWithTakeout<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeWithTakeout<R, T>(value, this.takeoutId, this.query);
    }

    public final ImmutableInvokeWithTakeout<R, T> withTakeoutId(long value) {
        if (this.takeoutId == value) {
            return this;
        }
        return new ImmutableInvokeWithTakeout<R, T>(this.identifier, value, this.query);
    }

    public final ImmutableInvokeWithTakeout<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeWithTakeout<R, TlMethod>(this.identifier, this.takeoutId, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeWithTakeout && this.equalTo(0, (ImmutableInvokeWithTakeout)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeWithTakeout<?, ?> another) {
        return this.identifier == another.identifier && this.takeoutId == another.takeoutId && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.takeoutId);
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeWithTakeout{identifier=" + this.identifier + ", takeoutId=" + this.takeoutId + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithTakeout<R, T> of(long takeoutId, T query) {
        return new ImmutableInvokeWithTakeout<R, T>(takeoutId, query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithTakeout<R, T> copyOf(InvokeWithTakeout<R, T> instance) {
        if (instance instanceof ImmutableInvokeWithTakeout) {
            return (ImmutableInvokeWithTakeout)instance;
        }
        return ImmutableInvokeWithTakeout.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_TAKEOUT_ID = 1L;
        private static final long INIT_BIT_QUERY = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private long takeoutId;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(InvokeWithTakeout<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InvokeWithTakeout) {
                instance = (InvokeWithTakeout)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.takeoutId(instance.takeoutId());
                this.query(instance.query());
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> takeoutId(long takeoutId) {
            this.takeoutId = takeoutId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableInvokeWithTakeout<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeWithTakeout(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("takeoutId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeWithTakeout, some of required attributes are not set " + attributes;
        }
    }
}

