/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlMethod;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.InvokeWithoutUpdates;

public final class ImmutableInvokeWithoutUpdates<R, T extends TlMethod<? extends R>>
implements InvokeWithoutUpdates<R, T> {
    private final int identifier;
    private final T query;

    private ImmutableInvokeWithoutUpdates(T query) {
        this.query = (TlMethod)Objects.requireNonNull(query, "query");
        this.identifier = InvokeWithoutUpdates.super.identifier();
    }

    private ImmutableInvokeWithoutUpdates(Builder<R, T> builder) {
        this.query = builder.query;
        this.identifier = builder.identifierIsSet() ? builder.identifier : InvokeWithoutUpdates.super.identifier();
    }

    private ImmutableInvokeWithoutUpdates(int identifier, T query) {
        this.identifier = identifier;
        this.query = query;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public T query() {
        return this.query;
    }

    public final ImmutableInvokeWithoutUpdates<R, T> withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableInvokeWithoutUpdates<R, T>(value, this.query);
    }

    public final ImmutableInvokeWithoutUpdates<R, T> withQuery(T value) {
        if (this.query == value) {
            return this;
        }
        TlMethod newValue = (TlMethod)Objects.requireNonNull(value, "query");
        return new ImmutableInvokeWithoutUpdates<R, TlMethod>(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvokeWithoutUpdates && this.equalTo(0, (ImmutableInvokeWithoutUpdates)another);
    }

    private boolean equalTo(int synthetic, ImmutableInvokeWithoutUpdates<?, ?> another) {
        return this.identifier == another.identifier && this.query.equals(another.query);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.query.hashCode();
        return h;
    }

    public String toString() {
        return "InvokeWithoutUpdates{identifier=" + this.identifier + ", query=" + this.query + "}";
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithoutUpdates<R, T> of(T query) {
        return new ImmutableInvokeWithoutUpdates<R, T>(query);
    }

    public static <R, T extends TlMethod<? extends R>> ImmutableInvokeWithoutUpdates<R, T> copyOf(InvokeWithoutUpdates<R, T> instance) {
        if (instance instanceof ImmutableInvokeWithoutUpdates) {
            return (ImmutableInvokeWithoutUpdates)instance;
        }
        return ImmutableInvokeWithoutUpdates.builder().from(instance).build();
    }

    public static <R, T extends TlMethod<? extends R>> Builder<R, T> builder() {
        return new Builder();
    }

    public static final class Builder<R, T extends TlMethod<? extends R>> {
        private static final long INIT_BIT_QUERY = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private T query;

        private Builder() {
        }

        public final Builder<R, T> from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder<R, T> from(InvokeWithoutUpdates<R, T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof InvokeWithoutUpdates) {
                instance = (InvokeWithoutUpdates)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.query(instance.query());
            }
        }

        public final Builder<R, T> identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder<R, T> query(T query) {
            this.query = (TlMethod)Objects.requireNonNull(query, "query");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableInvokeWithoutUpdates<R, T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvokeWithoutUpdates(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("query");
            }
            return "Cannot build InvokeWithoutUpdates, some of required attributes are not set " + attributes;
        }
    }
}

