/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import telegram4j.tl.SecureCredentialsEncrypted;
import telegram4j.tl.SecureValueHash;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.AcceptAuthorization;

public final class ImmutableAcceptAuthorization
implements AcceptAuthorization {
    private final int identifier;
    private final long botId;
    private final String scope;
    private final String publicKey;
    private final List<SecureValueHash> valueHashes;
    private final SecureCredentialsEncrypted credentials;

    private ImmutableAcceptAuthorization(long botId, String scope, String publicKey, SecureCredentialsEncrypted credentials) {
        this.botId = botId;
        this.scope = Objects.requireNonNull(scope, "scope");
        this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
        this.credentials = Objects.requireNonNull(credentials, "credentials");
        this.valueHashes = Collections.emptyList();
        this.identifier = AcceptAuthorization.super.identifier();
    }

    private ImmutableAcceptAuthorization(Builder builder) {
        this.botId = builder.botId;
        this.scope = builder.scope;
        this.publicKey = builder.publicKey;
        this.valueHashes = ImmutableAcceptAuthorization.createUnmodifiableList(true, builder.valueHashes);
        this.credentials = builder.credentials;
        this.identifier = builder.identifierIsSet() ? builder.identifier : AcceptAuthorization.super.identifier();
    }

    private ImmutableAcceptAuthorization(int identifier, long botId, String scope, String publicKey, List<SecureValueHash> valueHashes, SecureCredentialsEncrypted credentials) {
        this.identifier = identifier;
        this.botId = botId;
        this.scope = scope;
        this.publicKey = publicKey;
        this.valueHashes = valueHashes;
        this.credentials = credentials;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public long botId() {
        return this.botId;
    }

    @Override
    public String scope() {
        return this.scope;
    }

    @Override
    public String publicKey() {
        return this.publicKey;
    }

    @Override
    public List<SecureValueHash> valueHashes() {
        return this.valueHashes;
    }

    @Override
    public SecureCredentialsEncrypted credentials() {
        return this.credentials;
    }

    public final ImmutableAcceptAuthorization withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableAcceptAuthorization(value, this.botId, this.scope, this.publicKey, this.valueHashes, this.credentials);
    }

    public final ImmutableAcceptAuthorization withBotId(long value) {
        if (this.botId == value) {
            return this;
        }
        return new ImmutableAcceptAuthorization(this.identifier, value, this.scope, this.publicKey, this.valueHashes, this.credentials);
    }

    public final ImmutableAcceptAuthorization withScope(String value) {
        String newValue = Objects.requireNonNull(value, "scope");
        if (this.scope.equals(newValue)) {
            return this;
        }
        return new ImmutableAcceptAuthorization(this.identifier, this.botId, newValue, this.publicKey, this.valueHashes, this.credentials);
    }

    public final ImmutableAcceptAuthorization withPublicKey(String value) {
        String newValue = Objects.requireNonNull(value, "publicKey");
        if (this.publicKey.equals(newValue)) {
            return this;
        }
        return new ImmutableAcceptAuthorization(this.identifier, this.botId, this.scope, newValue, this.valueHashes, this.credentials);
    }

    public final ImmutableAcceptAuthorization withValueHashes(SecureValueHash ... elements) {
        List<SecureValueHash> newValue = ImmutableAcceptAuthorization.createUnmodifiableList(false, ImmutableAcceptAuthorization.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableAcceptAuthorization(this.identifier, this.botId, this.scope, this.publicKey, newValue, this.credentials);
    }

    public final ImmutableAcceptAuthorization withValueHashes(Iterable<? extends SecureValueHash> elements) {
        if (this.valueHashes == elements) {
            return this;
        }
        List<SecureValueHash> newValue = ImmutableAcceptAuthorization.createUnmodifiableList(false, ImmutableAcceptAuthorization.createSafeList(elements, true, false));
        return new ImmutableAcceptAuthorization(this.identifier, this.botId, this.scope, this.publicKey, newValue, this.credentials);
    }

    public final ImmutableAcceptAuthorization withCredentials(SecureCredentialsEncrypted value) {
        if (this.credentials == value) {
            return this;
        }
        SecureCredentialsEncrypted newValue = Objects.requireNonNull(value, "credentials");
        return new ImmutableAcceptAuthorization(this.identifier, this.botId, this.scope, this.publicKey, this.valueHashes, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptAuthorization && this.equalTo(0, (ImmutableAcceptAuthorization)another);
    }

    private boolean equalTo(int synthetic, ImmutableAcceptAuthorization another) {
        return this.identifier == another.identifier && this.botId == another.botId && this.scope.equals(another.scope) && this.publicKey.equals(another.publicKey) && this.valueHashes.equals(another.valueHashes) && this.credentials.equals(another.credentials);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + Long.hashCode(this.botId);
        h += (h << 5) + this.scope.hashCode();
        h += (h << 5) + this.publicKey.hashCode();
        h += (h << 5) + this.valueHashes.hashCode();
        h += (h << 5) + this.credentials.hashCode();
        return h;
    }

    public String toString() {
        return "AcceptAuthorization{identifier=" + this.identifier + ", botId=" + this.botId + ", scope=" + this.scope + ", publicKey=" + this.publicKey + ", valueHashes=" + this.valueHashes + ", credentials=" + this.credentials + "}";
    }

    public static ImmutableAcceptAuthorization of(long botId, String scope, String publicKey, SecureCredentialsEncrypted credentials) {
        return new ImmutableAcceptAuthorization(botId, scope, publicKey, credentials);
    }

    public static ImmutableAcceptAuthorization copyOf(AcceptAuthorization instance) {
        if (instance instanceof ImmutableAcceptAuthorization) {
            return (ImmutableAcceptAuthorization)instance;
        }
        return ImmutableAcceptAuthorization.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_BOT_ID = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private static final long INIT_BIT_PUBLIC_KEY = 4L;
        private static final long INIT_BIT_CREDENTIALS = 8L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 15L;
        private long optBits;
        private int identifier;
        private long botId;
        private String scope;
        private String publicKey;
        private List<SecureValueHash> valueHashes = new ArrayList<SecureValueHash>();
        private SecureCredentialsEncrypted credentials;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AcceptAuthorization instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof AcceptAuthorization) {
                instance = (AcceptAuthorization)object;
                this.addAllValueHashes(instance.valueHashes());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.botId(instance.botId());
                this.publicKey(instance.publicKey());
                this.credentials(instance.credentials());
                this.scope(instance.scope());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder botId(long botId) {
            this.botId = botId;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder scope(String scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder publicKey(String publicKey) {
            this.publicKey = Objects.requireNonNull(publicKey, "publicKey");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder addValueHashe(SecureValueHash element) {
            this.valueHashes.add(Objects.requireNonNull(element, "valueHashes element"));
            return this;
        }

        public final Builder addValueHashes(SecureValueHash ... elements) {
            for (SecureValueHash element : elements) {
                this.valueHashes.add(Objects.requireNonNull(element, "valueHashes element"));
            }
            return this;
        }

        public final Builder valueHashes(Iterable<? extends SecureValueHash> elements) {
            this.valueHashes.clear();
            return this.addAllValueHashes(elements);
        }

        public final Builder addAllValueHashes(Iterable<? extends SecureValueHash> elements) {
            for (SecureValueHash secureValueHash : elements) {
                this.valueHashes.add(Objects.requireNonNull(secureValueHash, "valueHashes element"));
            }
            return this;
        }

        public final Builder credentials(SecureCredentialsEncrypted credentials) {
            this.credentials = Objects.requireNonNull(credentials, "credentials");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public ImmutableAcceptAuthorization build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptAuthorization(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("botId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("publicKey");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("credentials");
            }
            return "Cannot build AcceptAuthorization, some of required attributes are not set " + attributes;
        }
    }
}

