/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ChangeAuthorizationSettings;

public final class ImmutableChangeAuthorizationSettings
implements ChangeAuthorizationSettings {
    private final int identifier;
    private final int flags;
    private final long hash;
    @Nullable
    private final Boolean encryptedRequestsDisabled;
    @Nullable
    private final Boolean callRequestsDisabled;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableChangeAuthorizationSettings(long hash) {
        this.hash = hash;
        this.encryptedRequestsDisabled = null;
        this.callRequestsDisabled = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChangeAuthorizationSettings(Builder builder) {
        this.hash = builder.hash;
        this.encryptedRequestsDisabled = builder.encryptedRequestsDisabled;
        this.callRequestsDisabled = builder.callRequestsDisabled;
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableChangeAuthorizationSettings(int identifier, int flags, long hash, @Nullable Boolean encryptedRequestsDisabled, @Nullable Boolean callRequestsDisabled) {
        this.identifier = identifier;
        this.flags = flags;
        this.hash = hash;
        this.encryptedRequestsDisabled = encryptedRequestsDisabled;
        this.callRequestsDisabled = callRequestsDisabled;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return ChangeAuthorizationSettings.super.identifier();
    }

    private int flagsInitialize() {
        return ChangeAuthorizationSettings.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public long hash() {
        return this.hash;
    }

    @Override
    @Nullable
    public Boolean encryptedRequestsDisabled() {
        return this.encryptedRequestsDisabled;
    }

    @Override
    @Nullable
    public Boolean callRequestsDisabled() {
        return this.callRequestsDisabled;
    }

    public final ImmutableChangeAuthorizationSettings withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChangeAuthorizationSettings(value, this.flags, this.hash, this.encryptedRequestsDisabled, this.callRequestsDisabled);
    }

    public final ImmutableChangeAuthorizationSettings withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableChangeAuthorizationSettings(this.identifier, value, this.hash, this.encryptedRequestsDisabled, this.callRequestsDisabled);
    }

    public final ImmutableChangeAuthorizationSettings withHash(long value) {
        if (this.hash == value) {
            return this;
        }
        return new ImmutableChangeAuthorizationSettings(this.identifier, this.flags, value, this.encryptedRequestsDisabled, this.callRequestsDisabled);
    }

    public final ImmutableChangeAuthorizationSettings withEncryptedRequestsDisabled(@Nullable Boolean value) {
        if (Objects.equals(this.encryptedRequestsDisabled, value)) {
            return this;
        }
        return new ImmutableChangeAuthorizationSettings(this.identifier, this.flags, this.hash, value, this.callRequestsDisabled);
    }

    public final ImmutableChangeAuthorizationSettings withCallRequestsDisabled(@Nullable Boolean value) {
        if (Objects.equals(this.callRequestsDisabled, value)) {
            return this;
        }
        return new ImmutableChangeAuthorizationSettings(this.identifier, this.flags, this.hash, this.encryptedRequestsDisabled, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChangeAuthorizationSettings && this.equalTo(0, (ImmutableChangeAuthorizationSettings)another);
    }

    private boolean equalTo(int synthetic, ImmutableChangeAuthorizationSettings another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.hash == another.hash && Objects.equals(this.encryptedRequestsDisabled, another.encryptedRequestsDisabled) && Objects.equals(this.callRequestsDisabled, another.callRequestsDisabled);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + Long.hashCode(this.hash);
        h += (h << 5) + Objects.hashCode(this.encryptedRequestsDisabled);
        h += (h << 5) + Objects.hashCode(this.callRequestsDisabled);
        return h;
    }

    public String toString() {
        return "ChangeAuthorizationSettings{identifier=" + this.identifier + ", flags=" + this.flags + ", hash=" + this.hash + ", encryptedRequestsDisabled=" + this.encryptedRequestsDisabled + ", callRequestsDisabled=" + this.callRequestsDisabled + "}";
    }

    public static ImmutableChangeAuthorizationSettings of(long hash) {
        return new ImmutableChangeAuthorizationSettings(hash);
    }

    public static ImmutableChangeAuthorizationSettings copyOf(ChangeAuthorizationSettings instance) {
        if (instance instanceof ImmutableChangeAuthorizationSettings) {
            return (ImmutableChangeAuthorizationSettings)instance;
        }
        return ImmutableChangeAuthorizationSettings.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_HASH = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private int flags;
        private long hash;
        private Boolean encryptedRequestsDisabled;
        private Boolean callRequestsDisabled;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ChangeAuthorizationSettings instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof ChangeAuthorizationSettings) {
                Boolean callRequestsDisabledValue;
                Boolean encryptedRequestsDisabledValue;
                instance = (ChangeAuthorizationSettings)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((encryptedRequestsDisabledValue = instance.encryptedRequestsDisabled()) != null) {
                    this.encryptedRequestsDisabled(encryptedRequestsDisabledValue);
                }
                if ((callRequestsDisabledValue = instance.callRequestsDisabled()) != null) {
                    this.callRequestsDisabled(callRequestsDisabledValue);
                }
                this.hash(instance.hash());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder hash(long hash) {
            this.hash = hash;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder encryptedRequestsDisabled(@Nullable Boolean encryptedRequestsDisabled) {
            this.encryptedRequestsDisabled = encryptedRequestsDisabled;
            return this;
        }

        public final Builder callRequestsDisabled(@Nullable Boolean callRequestsDisabled) {
            this.callRequestsDisabled = callRequestsDisabled;
            return this;
        }

        public ImmutableChangeAuthorizationSettings build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChangeAuthorizationSettings(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("hash");
            }
            return "Cannot build ChangeAuthorizationSettings, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableChangeAuthorizationSettings.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableChangeAuthorizationSettings.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build ChangeAuthorizationSettings, attribute initializers form cycle " + attributes;
        }
    }
}

