/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ChangePhone;

public final class ImmutableChangePhone
implements ChangePhone {
    private final int identifier;
    private final String phoneNumber;
    private final String phoneCodeHash;
    private final String phoneCode;

    private ImmutableChangePhone(String phoneNumber, String phoneCodeHash, String phoneCode) {
        this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
        this.identifier = ChangePhone.super.identifier();
    }

    private ImmutableChangePhone(Builder builder) {
        this.phoneNumber = builder.phoneNumber;
        this.phoneCodeHash = builder.phoneCodeHash;
        this.phoneCode = builder.phoneCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ChangePhone.super.identifier();
    }

    private ImmutableChangePhone(int identifier, String phoneNumber, String phoneCodeHash, String phoneCode) {
        this.identifier = identifier;
        this.phoneNumber = phoneNumber;
        this.phoneCodeHash = phoneCodeHash;
        this.phoneCode = phoneCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneNumber() {
        return this.phoneNumber;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    @Override
    public String phoneCode() {
        return this.phoneCode;
    }

    public final ImmutableChangePhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableChangePhone(value, this.phoneNumber, this.phoneCodeHash, this.phoneCode);
    }

    public final ImmutableChangePhone withPhoneNumber(String value) {
        String newValue = Objects.requireNonNull(value, "phoneNumber");
        if (this.phoneNumber.equals(newValue)) {
            return this;
        }
        return new ImmutableChangePhone(this.identifier, newValue, this.phoneCodeHash, this.phoneCode);
    }

    public final ImmutableChangePhone withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableChangePhone(this.identifier, this.phoneNumber, newValue, this.phoneCode);
    }

    public final ImmutableChangePhone withPhoneCode(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCode");
        if (this.phoneCode.equals(newValue)) {
            return this;
        }
        return new ImmutableChangePhone(this.identifier, this.phoneNumber, this.phoneCodeHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableChangePhone && this.equalTo(0, (ImmutableChangePhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableChangePhone another) {
        return this.identifier == another.identifier && this.phoneNumber.equals(another.phoneNumber) && this.phoneCodeHash.equals(another.phoneCodeHash) && this.phoneCode.equals(another.phoneCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneNumber.hashCode();
        h += (h << 5) + this.phoneCodeHash.hashCode();
        h += (h << 5) + this.phoneCode.hashCode();
        return h;
    }

    public String toString() {
        return "ChangePhone{identifier=" + this.identifier + ", phoneNumber=" + this.phoneNumber + ", phoneCodeHash=" + this.phoneCodeHash + ", phoneCode=" + this.phoneCode + "}";
    }

    public static ImmutableChangePhone of(String phoneNumber, String phoneCodeHash, String phoneCode) {
        return new ImmutableChangePhone(phoneNumber, phoneCodeHash, phoneCode);
    }

    public static ImmutableChangePhone copyOf(ChangePhone instance) {
        if (instance instanceof ImmutableChangePhone) {
            return (ImmutableChangePhone)instance;
        }
        return ImmutableChangePhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_NUMBER = 1L;
        private static final long INIT_BIT_PHONE_CODE_HASH = 2L;
        private static final long INIT_BIT_PHONE_CODE = 4L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 7L;
        private long optBits;
        private int identifier;
        private String phoneNumber;
        private String phoneCodeHash;
        private String phoneCode;

        private Builder() {
        }

        public final Builder from(ChangePhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ChangePhone instance;
            long bits = 0L;
            if (object instanceof ChangePhone) {
                instance = (ChangePhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCode(instance.phoneCode());
                this.phoneNumber(instance.phoneNumber());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneNumber(String phoneNumber) {
            this.phoneNumber = Objects.requireNonNull(phoneNumber, "phoneNumber");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder phoneCode(String phoneCode) {
            this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableChangePhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableChangePhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneNumber");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("phoneCode");
            }
            return "Cannot build ChangePhone, some of required attributes are not set " + attributes;
        }
    }
}

