/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.CheckUsername;

public final class ImmutableCheckUsername
implements CheckUsername {
    private final int identifier;
    private final String username;

    private ImmutableCheckUsername(String username) {
        this.username = Objects.requireNonNull(username, "username");
        this.identifier = CheckUsername.super.identifier();
    }

    private ImmutableCheckUsername(Builder builder) {
        this.username = builder.username;
        this.identifier = builder.identifierIsSet() ? builder.identifier : CheckUsername.super.identifier();
    }

    private ImmutableCheckUsername(int identifier, String username) {
        this.identifier = identifier;
        this.username = username;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String username() {
        return this.username;
    }

    public final ImmutableCheckUsername withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCheckUsername(value, this.username);
    }

    public final ImmutableCheckUsername withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableCheckUsername(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCheckUsername && this.equalTo(0, (ImmutableCheckUsername)another);
    }

    private boolean equalTo(int synthetic, ImmutableCheckUsername another) {
        return this.identifier == another.identifier && this.username.equals(another.username);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.username.hashCode();
        return h;
    }

    public String toString() {
        return "CheckUsername{identifier=" + this.identifier + ", username=" + this.username + "}";
    }

    public static ImmutableCheckUsername of(String username) {
        return new ImmutableCheckUsername(username);
    }

    public static ImmutableCheckUsername copyOf(CheckUsername instance) {
        if (instance instanceof ImmutableCheckUsername) {
            return (ImmutableCheckUsername)instance;
        }
        return ImmutableCheckUsername.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String username;

        private Builder() {
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(CheckUsername instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
            if (object instanceof CheckUsername) {
                instance = (CheckUsername)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.username(instance.username());
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableCheckUsername build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCheckUsername(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build CheckUsername, some of required attributes are not set " + attributes;
        }
    }
}

