/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ConfirmPasswordEmail;

public final class ImmutableConfirmPasswordEmail
implements ConfirmPasswordEmail {
    private final int identifier;
    private final String code;

    private ImmutableConfirmPasswordEmail(String code) {
        this.code = Objects.requireNonNull(code, "code");
        this.identifier = ConfirmPasswordEmail.super.identifier();
    }

    private ImmutableConfirmPasswordEmail(Builder builder) {
        this.code = builder.code;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ConfirmPasswordEmail.super.identifier();
    }

    private ImmutableConfirmPasswordEmail(int identifier, String code) {
        this.identifier = identifier;
        this.code = code;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String code() {
        return this.code;
    }

    public final ImmutableConfirmPasswordEmail withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableConfirmPasswordEmail(value, this.code);
    }

    public final ImmutableConfirmPasswordEmail withCode(String value) {
        String newValue = Objects.requireNonNull(value, "code");
        if (this.code.equals(newValue)) {
            return this;
        }
        return new ImmutableConfirmPasswordEmail(this.identifier, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfirmPasswordEmail && this.equalTo(0, (ImmutableConfirmPasswordEmail)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfirmPasswordEmail another) {
        return this.identifier == another.identifier && this.code.equals(another.code);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.code.hashCode();
        return h;
    }

    public String toString() {
        return "ConfirmPasswordEmail{identifier=" + this.identifier + ", code=" + this.code + "}";
    }

    public static ImmutableConfirmPasswordEmail of(String code) {
        return new ImmutableConfirmPasswordEmail(code);
    }

    public static ImmutableConfirmPasswordEmail copyOf(ConfirmPasswordEmail instance) {
        if (instance instanceof ImmutableConfirmPasswordEmail) {
            return (ImmutableConfirmPasswordEmail)instance;
        }
        return ImmutableConfirmPasswordEmail.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_CODE = 1L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 1L;
        private long optBits;
        private int identifier;
        private String code;

        private Builder() {
        }

        public final Builder from(ConfirmPasswordEmail instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConfirmPasswordEmail instance;
            long bits = 0L;
            if (object instanceof ConfirmPasswordEmail) {
                instance = (ConfirmPasswordEmail)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.code(instance.code());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder code(String code) {
            this.code = Objects.requireNonNull(code, "code");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableConfirmPasswordEmail build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfirmPasswordEmail(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("code");
            }
            return "Cannot build ConfirmPasswordEmail, some of required attributes are not set " + attributes;
        }
    }
}

