/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Objects;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.ConfirmPhone;

public final class ImmutableConfirmPhone
implements ConfirmPhone {
    private final int identifier;
    private final String phoneCodeHash;
    private final String phoneCode;

    private ImmutableConfirmPhone(String phoneCodeHash, String phoneCode) {
        this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
        this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
        this.identifier = ConfirmPhone.super.identifier();
    }

    private ImmutableConfirmPhone(Builder builder) {
        this.phoneCodeHash = builder.phoneCodeHash;
        this.phoneCode = builder.phoneCode;
        this.identifier = builder.identifierIsSet() ? builder.identifier : ConfirmPhone.super.identifier();
    }

    private ImmutableConfirmPhone(int identifier, String phoneCodeHash, String phoneCode) {
        this.identifier = identifier;
        this.phoneCodeHash = phoneCodeHash;
        this.phoneCode = phoneCode;
    }

    @Override
    public int identifier() {
        return this.identifier;
    }

    @Override
    public String phoneCodeHash() {
        return this.phoneCodeHash;
    }

    @Override
    public String phoneCode() {
        return this.phoneCode;
    }

    public final ImmutableConfirmPhone withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableConfirmPhone(value, this.phoneCodeHash, this.phoneCode);
    }

    public final ImmutableConfirmPhone withPhoneCodeHash(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCodeHash");
        if (this.phoneCodeHash.equals(newValue)) {
            return this;
        }
        return new ImmutableConfirmPhone(this.identifier, newValue, this.phoneCode);
    }

    public final ImmutableConfirmPhone withPhoneCode(String value) {
        String newValue = Objects.requireNonNull(value, "phoneCode");
        if (this.phoneCode.equals(newValue)) {
            return this;
        }
        return new ImmutableConfirmPhone(this.identifier, this.phoneCodeHash, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableConfirmPhone && this.equalTo(0, (ImmutableConfirmPhone)another);
    }

    private boolean equalTo(int synthetic, ImmutableConfirmPhone another) {
        return this.identifier == another.identifier && this.phoneCodeHash.equals(another.phoneCodeHash) && this.phoneCode.equals(another.phoneCode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.phoneCodeHash.hashCode();
        h += (h << 5) + this.phoneCode.hashCode();
        return h;
    }

    public String toString() {
        return "ConfirmPhone{identifier=" + this.identifier + ", phoneCodeHash=" + this.phoneCodeHash + ", phoneCode=" + this.phoneCode + "}";
    }

    public static ImmutableConfirmPhone of(String phoneCodeHash, String phoneCode) {
        return new ImmutableConfirmPhone(phoneCodeHash, phoneCode);
    }

    public static ImmutableConfirmPhone copyOf(ConfirmPhone instance) {
        if (instance instanceof ImmutableConfirmPhone) {
            return (ImmutableConfirmPhone)instance;
        }
        return ImmutableConfirmPhone.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final long INIT_BIT_PHONE_CODE_HASH = 1L;
        private static final long INIT_BIT_PHONE_CODE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private String phoneCodeHash;
        private String phoneCode;

        private Builder() {
        }

        public final Builder from(ConfirmPhone instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ConfirmPhone instance;
            long bits = 0L;
            if (object instanceof ConfirmPhone) {
                instance = (ConfirmPhone)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                this.phoneCode(instance.phoneCode());
                this.phoneCodeHash(instance.phoneCodeHash());
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder phoneCodeHash(String phoneCodeHash) {
            this.phoneCodeHash = Objects.requireNonNull(phoneCodeHash, "phoneCodeHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder phoneCode(String phoneCode) {
            this.phoneCode = Objects.requireNonNull(phoneCode, "phoneCode");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableConfirmPhone build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableConfirmPhone(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("phoneCodeHash");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("phoneCode");
            }
            return "Cannot build ConfirmPhone, some of required attributes are not set " + attributes;
        }
    }
}

