/*
 * Decompiled with CFR 0.152.
 */
package telegram4j.tl.request.account;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import reactor.util.annotation.Nullable;
import telegram4j.tl.InputDocument;
import telegram4j.tl.InputThemeSettings;
import telegram4j.tl.api.TlObject;
import telegram4j.tl.request.account.CreateTheme;

public final class ImmutableCreateTheme
implements CreateTheme {
    private final int identifier;
    private final int flags;
    private final String slug;
    private final String title;
    @Nullable
    private final InputDocument document;
    @Nullable
    private final List<InputThemeSettings> settings;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableCreateTheme(String slug, String title) {
        this.slug = Objects.requireNonNull(slug, "slug");
        this.title = Objects.requireNonNull(title, "title");
        this.document = null;
        this.settings = null;
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableCreateTheme(Builder builder) {
        this.slug = builder.slug;
        this.title = builder.title;
        this.document = builder.document;
        List<InputThemeSettings> list = this.settings = builder.settings == null ? null : ImmutableCreateTheme.createUnmodifiableList(true, builder.settings);
        if (builder.identifierIsSet()) {
            this.initShim.identifier(builder.identifier);
        }
        if (builder.flagsIsSet()) {
            this.initShim.flags(builder.flags);
        }
        this.identifier = this.initShim.identifier();
        this.flags = this.initShim.flags();
        this.initShim = null;
    }

    private ImmutableCreateTheme(int identifier, int flags, String slug, String title, @Nullable InputDocument document, @Nullable List<InputThemeSettings> settings) {
        this.identifier = identifier;
        this.flags = flags;
        this.slug = slug;
        this.title = title;
        this.document = document;
        this.settings = settings;
        this.initShim = null;
    }

    private int identifierInitialize() {
        return CreateTheme.super.identifier();
    }

    private int flagsInitialize() {
        return CreateTheme.super.flags();
    }

    @Override
    public int identifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.identifier() : this.identifier;
    }

    @Override
    public int flags() {
        InitShim shim = this.initShim;
        return shim != null ? shim.flags() : this.flags;
    }

    @Override
    public String slug() {
        return this.slug;
    }

    @Override
    public String title() {
        return this.title;
    }

    @Override
    @Nullable
    public InputDocument document() {
        return this.document;
    }

    @Override
    @Nullable
    public List<InputThemeSettings> settings() {
        return this.settings;
    }

    public final ImmutableCreateTheme withIdentifier(int value) {
        if (this.identifier == value) {
            return this;
        }
        return new ImmutableCreateTheme(value, this.flags, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableCreateTheme withFlags(int value) {
        if (this.flags == value) {
            return this;
        }
        return new ImmutableCreateTheme(this.identifier, value, this.slug, this.title, this.document, this.settings);
    }

    public final ImmutableCreateTheme withSlug(String value) {
        String newValue = Objects.requireNonNull(value, "slug");
        if (this.slug.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTheme(this.identifier, this.flags, newValue, this.title, this.document, this.settings);
    }

    public final ImmutableCreateTheme withTitle(String value) {
        String newValue = Objects.requireNonNull(value, "title");
        if (this.title.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateTheme(this.identifier, this.flags, this.slug, newValue, this.document, this.settings);
    }

    public final ImmutableCreateTheme withDocument(@Nullable InputDocument value) {
        if (this.document == value) {
            return this;
        }
        return new ImmutableCreateTheme(this.identifier, this.flags, this.slug, this.title, value, this.settings);
    }

    public final ImmutableCreateTheme withSettings(InputThemeSettings ... elements) {
        if (elements == null) {
            return new ImmutableCreateTheme(this.identifier, this.flags, this.slug, this.title, this.document, null);
        }
        List<InputThemeSettings> newValue = Arrays.asList(elements) == null ? null : ImmutableCreateTheme.createUnmodifiableList(false, ImmutableCreateTheme.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableCreateTheme(this.identifier, this.flags, this.slug, this.title, this.document, newValue);
    }

    public final ImmutableCreateTheme withSettings(@Nullable Iterable<? extends InputThemeSettings> elements) {
        if (this.settings == elements) {
            return this;
        }
        List<InputThemeSettings> newValue = elements == null ? null : ImmutableCreateTheme.createUnmodifiableList(false, ImmutableCreateTheme.createSafeList(elements, true, false));
        return new ImmutableCreateTheme(this.identifier, this.flags, this.slug, this.title, this.document, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateTheme && this.equalTo(0, (ImmutableCreateTheme)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateTheme another) {
        return this.identifier == another.identifier && this.flags == another.flags && this.slug.equals(another.slug) && this.title.equals(another.title) && Objects.equals(this.document, another.document) && Objects.equals(this.settings, another.settings);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.identifier;
        h += (h << 5) + this.flags;
        h += (h << 5) + this.slug.hashCode();
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + Objects.hashCode(this.document);
        h += (h << 5) + Objects.hashCode(this.settings);
        return h;
    }

    public String toString() {
        return "CreateTheme{identifier=" + this.identifier + ", flags=" + this.flags + ", slug=" + this.slug + ", title=" + this.title + ", document=" + this.document + ", settings=" + this.settings + "}";
    }

    public static ImmutableCreateTheme of(String slug, String title) {
        return new ImmutableCreateTheme(slug, title);
    }

    public static ImmutableCreateTheme copyOf(CreateTheme instance) {
        if (instance instanceof ImmutableCreateTheme) {
            return (ImmutableCreateTheme)instance;
        }
        return ImmutableCreateTheme.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    public static final class Builder {
        private static final long INIT_BIT_SLUG = 1L;
        private static final long INIT_BIT_TITLE = 2L;
        private static final long OPT_BIT_IDENTIFIER = 1L;
        private static final long OPT_BIT_FLAGS = 2L;
        private long initBits = 3L;
        private long optBits;
        private int identifier;
        private int flags;
        private String slug;
        private String title;
        private InputDocument document;
        private List<InputThemeSettings> settings = null;

        private Builder() {
        }

        public final Builder from(CreateTheme instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(TlObject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            CreateTheme instance;
            long bits = 0L;
            if (object instanceof CreateTheme) {
                List<InputThemeSettings> settingsValue;
                instance = (CreateTheme)object;
                this.flags(instance.flags());
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
                if ((settingsValue = instance.settings()) != null) {
                    this.addAllSettings(settingsValue);
                }
                this.title(instance.title());
                this.slug(instance.slug());
                InputDocument documentValue = instance.document();
                if (documentValue != null) {
                    this.document(documentValue);
                }
            }
            if (object instanceof TlObject) {
                instance = (TlObject)object;
                if ((bits & 1L) == 0L) {
                    this.identifier(instance.identifier());
                    bits |= 1L;
                }
            }
        }

        public final Builder identifier(int identifier) {
            this.identifier = identifier;
            this.optBits |= 1L;
            return this;
        }

        public final Builder flags(int flags) {
            this.flags = flags;
            this.optBits |= 2L;
            return this;
        }

        public final Builder slug(String slug) {
            this.slug = Objects.requireNonNull(slug, "slug");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder title(String title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder document(@Nullable InputDocument document) {
            this.document = document;
            return this;
        }

        public final Builder addSetting(InputThemeSettings element) {
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            this.settings.add(Objects.requireNonNull(element, "settings element"));
            return this;
        }

        public final Builder addSettings(InputThemeSettings ... elements) {
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            for (InputThemeSettings element : elements) {
                this.settings.add(Objects.requireNonNull(element, "settings element"));
            }
            return this;
        }

        public final Builder settings(@Nullable Iterable<? extends InputThemeSettings> elements) {
            if (elements == null) {
                this.settings = null;
                return this;
            }
            this.settings = new ArrayList<InputThemeSettings>();
            return this.addAllSettings(elements);
        }

        public final Builder addAllSettings(Iterable<? extends InputThemeSettings> elements) {
            Objects.requireNonNull(elements, "settings element");
            if (this.settings == null) {
                this.settings = new ArrayList<InputThemeSettings>();
            }
            for (InputThemeSettings inputThemeSettings : elements) {
                this.settings.add(Objects.requireNonNull(inputThemeSettings, "settings element"));
            }
            return this;
        }

        public ImmutableCreateTheme build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateTheme(this);
        }

        private boolean identifierIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean flagsIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("slug");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("title");
            }
            return "Cannot build CreateTheme, some of required attributes are not set " + attributes;
        }
    }

    private final class InitShim {
        private byte identifierBuildStage = 0;
        private int identifier;
        private byte flagsBuildStage = 0;
        private int flags;

        private InitShim() {
        }

        int identifier() {
            if (this.identifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.identifierBuildStage == 0) {
                this.identifierBuildStage = (byte)-1;
                this.identifier = ImmutableCreateTheme.this.identifierInitialize();
                this.identifierBuildStage = 1;
            }
            return this.identifier;
        }

        void identifier(int identifier) {
            this.identifier = identifier;
            this.identifierBuildStage = 1;
        }

        int flags() {
            if (this.flagsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.flagsBuildStage == 0) {
                this.flagsBuildStage = (byte)-1;
                this.flags = ImmutableCreateTheme.this.flagsInitialize();
                this.flagsBuildStage = 1;
            }
            return this.flags;
        }

        void flags(int flags) {
            this.flags = flags;
            this.flagsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.identifierBuildStage == -1) {
                attributes.add("identifier");
            }
            if (this.flagsBuildStage == -1) {
                attributes.add("flags");
            }
            return "Cannot build CreateTheme, attribute initializers form cycle " + attributes;
        }
    }
}

